"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _full_body_height_css = require("@kbn/css-utils/public/full_body_height_css");
var _react2 = require("@emotion/react");
var _components = require("./components");
var _contexts = require("./contexts");
var _lib = require("./lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    // App root page container
    appRoot: (0, _react2.css)([{
      overflow: 'hidden',
      flex: '1 1 auto'
    },
    // adding dev tool top bar to the body offset
    (0, _full_body_height_css.kbnFullBodyHeightCss)(`(${euiTheme.size.base} * 3)`)]),
    // Page body container
    pageBody: (0, _react2.css)`
      height: 100%;
      flex: 1 1 auto;
    `,
    // Page body content panel
    pageBodyContent: (0, _react2.css)`
      height: 100%;
    `,
    // Main body group
    bodyGroup: (0, _react2.css)`
      height: 100%;
    `,
    // Main content area
    main: (0, _react2.css)`
      height: 100%;
      flex-grow: 1;
      order: 2;
      margin-left: ${euiTheme.size.base};
      display: flex;
      overflow: hidden;
      flex-direction: column;

      // Make only the tab content scroll
      .search-profiler-tabs {
        flex-shrink: 0;
      }

      ${(0, _eui.useEuiBreakpoint)(['xs', 's'])} {
        flex: 0 0 auto;
        margin: ${euiTheme.size.base} 0;
      }
    `
  };
};
const App = () => {
  const {
    getLicenseStatus,
    notifications
  } = (0, _contexts.useAppContext)();
  const {
    activeTab,
    currentResponse,
    highlightDetails,
    pristine,
    profiling
  } = (0, _contexts.useProfilerReadContext)();
  const dispatch = (0, _contexts.useProfilerActionContext)();
  const styles = useStyles();
  const handleProfileTreeError = e => {
    notifications.addError(e, {
      title: _i18n.i18n.translate('xpack.searchProfiler.profileTreeErrorRenderTitle', {
        defaultMessage: 'Profile data cannot be parsed.'
      })
    });
  };
  const setActiveTab = (0, _react.useCallback)(target => dispatch({
    type: 'setActiveTab',
    value: target
  }), [dispatch]);
  const onHighlight = (0, _react.useCallback)(value => dispatch({
    type: 'setHighlightDetails',
    value
  }), [dispatch]);
  const renderLicenseWarning = () => {
    return !getLicenseStatus().valid ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.LicenseWarningNotice, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    })) : null;
  };
  const renderProfileTreeArea = () => {
    if (profiling) {
      return /*#__PURE__*/_react.default.createElement(_components.ProfileLoadingPlaceholder, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 14
        }
      });
    }
    if (activeTab) {
      return /*#__PURE__*/_react.default.createElement(_components.ProfileTree, {
        onDataInitError: handleProfileTreeError,
        onHighlight: onHighlight,
        target: activeTab,
        data: currentResponse,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 9
        }
      });
    }
    if (getLicenseStatus().valid && pristine) {
      return /*#__PURE__*/_react.default.createElement(_components.EmptyTreePlaceHolder, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 14
        }
      });
    }
    return null;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    css: styles.appRoot,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    css: styles.pageBody,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, renderLicenseWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: styles.pageBodyContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    direction: "row",
    css: styles.bodyGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ProfileQueryEditor, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.main,
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_components.SearchProfilerTabs, {
    activeTab: activeTab,
    activateTab: setActiveTab,
    has: {
      aggregations: Boolean(currentResponse && (0, _lib.hasAggregations)(currentResponse)),
      searches: Boolean(currentResponse && (0, _lib.hasSearch)(currentResponse))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 19
    }
  }), renderProfileTreeArea()))), highlightDetails ? /*#__PURE__*/_react.default.createElement(_components.HighlightDetailsFlyout, (0, _extends2.default)({}, highlightDetails, {
    onClose: () => dispatch({
      type: 'setHighlightDetails',
      value: null
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  })) : null))));
};
exports.App = App;