"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectToApiFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _tryInConsole = require("@kbn/try-in-console");
var _doc_links = require("../../../common/doc_links");
var _code_examples = require("./code_examples");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_synonyms/public/components/connect_to_api/connect_to_api_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConnectToApiFlyout = ({
  onClose,
  rulesetId
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    cloud,
    application,
    share,
    console: consolePlugin
  } = (0, _use_kibana.useKibana)().services;
  const isServerless = Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m",
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.title', {
    defaultMessage: 'Connect with the API'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.description', {
    defaultMessage: 'You can access and manage this synonym set from the API.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchSynonymsConnectToApiFlyoutViewFullApiReferenceLink",
    href: _doc_links.docLinks.synonymsApi,
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.viewFullApiReference', {
    defaultMessage: 'View full API reference'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.description', {
    defaultMessage: `You can specify the analyzer that contains your synonyms set as a search time analyzer.`
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }), _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.description.example', {
    defaultMessage: `The following example adds my_analyzer as a search analyzer to the title field in an index mapping`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "connectToIndexNewIndexAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.exampleButton.newIndex', {
      defaultMessage: 'Assigning to a new index'
    }))),
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    fontSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, (0, _code_examples.getExampleCode)(rulesetId)))), !isServerless && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "connectToIndexExistingIndexAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.exampleButton.existingIndex', {
      defaultMessage: 'Assigning to an existing index'
    }))),
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    fontSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  }, (0, _code_examples.getExistingIndexExampleCode)(rulesetId)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    "aria-label": _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.close', {
      defaultMessage: 'Close'
    }),
    "data-test-subj": "searchSynonymsConnectToApiFlyoutButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.close', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    request: (0, _code_examples.getExampleCode)(rulesetId),
    onClick: onClose,
    application: application,
    sharePlugin: share,
    consolePlugin: consolePlugin,
    type: "button",
    showIcon: false,
    "data-test-subj": "searchSynonymsConnectToApiFlyoutRunInConsoleButton",
    buttonProps: {
      fill: true,
      size: 'm'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  })))));
};
exports.ConnectToApiFlyout = ConnectToApiFlyout;