"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceEndpointsHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("../../common/translations"));
var _constants = require("../../common/constants");
var _doc_links = require("../../common/doc_links");
var _use_trained_model_page_url = require("../hooks/use_trained_model_page_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/inference_endpoints_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InferenceEndpointsHeader = ({
  onFlyoutOpen
}) => {
  const trainedModelPageUrl = (0, _use_trained_model_page_url.useTrainedModelPageUrl)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    "data-test-subj": "allInferenceEndpointsPage",
    pageTitle: _constants.PLUGIN_TITLE,
    description: i18n.MANAGE_INFERENCE_ENDPOINTS_LABEL,
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      fill: true,
      iconSize: "m",
      "data-test-subj": "add-inference-endpoint-header-button",
      onClick: onFlyoutOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }, i18n.ADD_ENDPOINT_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": i18n.API_DOCUMENTATION_LINK,
      iconType: "popout",
      iconSide: "right",
      iconSize: "s",
      flush: "both",
      target: "_blank",
      "data-test-subj": "api-documentation",
      href: _doc_links.docLinks.createInferenceEndpoint,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }, i18n.API_DOCUMENTATION_LINK), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": i18n.VIEW_YOUR_MODELS_LINK,
      href: trainedModelPageUrl,
      iconType: "popout",
      iconSide: "right",
      iconSize: "s",
      flush: "both",
      target: "_blank",
      "data-test-subj": "view-your-models",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, i18n.VIEW_YOUR_MODELS_LINK), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": i18n.EIS_DOCUMENTATION_LINK,
      href: _doc_links.docLinks.elasticInferenceService,
      iconType: "popout",
      iconSide: "right",
      iconSize: "s",
      flush: "both",
      target: "_blank",
      "data-test-subj": "eis-documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, i18n.EIS_DOCUMENTATION_LINK)],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
};
exports.InferenceEndpointsHeader = InferenceEndpointsHeader;