"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeywordSearch = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _ai_search_workflow = require("./ai_search_workflow");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/ai_search_capabilities/keyword_search.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const KeywordSearch = () => {
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const keywordSearchText = {
    image: `${assetBasePath}/keyword_search.svg`,
    imageAlt: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.keywordSearch.imageAlt', {
      defaultMessage: 'Keyword search'
    }),
    heading: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.keywordSearch.title', {
      defaultMessage: 'Setup your application with Elasticsearch’s full-text search capabilities'
    }),
    subheading: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.keywordSearch.description', {
      defaultMessage: 'Use a semantic_text field and Elastic’s built-in ELSER machine learning model.'
    }),
    featureBullets: [_i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.keywordSearch.firstLine', {
      defaultMessage: 'Enhanced query flexibility to create complex search functionalities.'
    }), _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.keywordSearch.secondLine', {
      defaultMessage: 'Scalable architecture accommodates growing data sets.'
    }), _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.keywordSearch.thirdLine', {
      defaultMessage: 'Enable precise results by targeting for users or other query conditions.'
    })],
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.keywordSearch.createKeywordIndex', {
      defaultMessage: 'Create a keyword index'
    }),
    dataTestSubj: 'createKeywordIndexButton',
    workflow: 'default'
  };
  return /*#__PURE__*/_react.default.createElement(_ai_search_workflow.AISearchWorkflow, {
    capability: keywordSearchText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 10
    }
  });
};
exports.KeywordSearch = KeywordSearch;