"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../../utils");
var _connector_configuration_utils = require("../../utils/connector_configuration_utils");
var _connector_configuration_form_items = require("./connector_configuration_form_items");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/configuration/connector_configuration_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function configViewToConfigValues(configView) {
  const result = {};
  for (const {
    key,
    value
  } of configView.advancedConfigurations) {
    result[key] = value;
  }
  for (const {
    key,
    value
  } of configView.unCategorizedItems) {
    result[key] = value;
  }
  return result;
}
const ConnectorConfigurationForm = ({
  cancelEditing,
  configuration,
  hasDocumentLevelSecurity,
  isLoading,
  isNative,
  saveConfig,
  saveAndSync
}) => {
  const [localConfig, setLocalConfig] = (0, _react.useState)(configuration);
  const [configView, setConfigView] = (0, _react.useState)((0, _connector_configuration_utils.sortAndFilterConnectorConfiguration)(configuration, isNative));
  (0, _react.useEffect)(() => {
    setLocalConfig(localConf => ({
      ...configuration,
      ...localConf
    }));
  }, [configuration]);
  (0, _react.useEffect)(() => {
    setConfigView((0, _connector_configuration_utils.sortAndFilterConnectorConfiguration)(localConfig, isNative));
  }, [localConfig, isNative]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: event => {
      event.preventDefault();
      saveConfig(configViewToConfigValues(configView));
    },
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_configuration_form_items.ConnectorConfigurationFormItems, {
    isLoading: isLoading,
    items: configView.unCategorizedItems,
    hasDocumentLevelSecurityEnabled: hasDocumentLevelSecurity,
    setConfigEntry: (key, value) => {
      const entry = localConfig[key];
      if (entry && !(0, _utils.isCategoryEntry)(entry)) {
        const newConfiguration = {
          ...localConfig,
          [key]: {
            ...entry,
            value
          }
        };
        setLocalConfig(newConfiguration);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }), configView.categories.map((category, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, category.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_connector_configuration_form_items.ConnectorConfigurationFormItems, {
    isLoading: isLoading,
    items: category.configEntries,
    hasDocumentLevelSecurityEnabled: hasDocumentLevelSecurity,
    setConfigEntry: (key, value) => {
      const entry = localConfig[key];
      if (entry && !(0, _utils.isCategoryEntry)(entry)) {
        const newConfiguration = {
          ...localConfig,
          [key]: {
            ...entry,
            value
          }
        };
        setLocalConfig(newConfiguration);
      }
      const categories = configView.categories;
      categories[index] = {
        ...categories[index],
        [key]: value
      };
      setConfigView({
        ...configView,
        categories
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }))), configView.advancedConfigurations.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.advancedConfigurations.title', {
    defaultMessage: 'Advanced Configurations'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_configuration_form_items.ConnectorConfigurationFormItems, {
    isLoading: isLoading,
    items: configView.advancedConfigurations,
    hasDocumentLevelSecurityEnabled: hasDocumentLevelSecurity,
    setConfigEntry: (key, value) => {
      const entry = localConfig[key];
      if (entry && !(0, _utils.isCategoryEntry)(entry)) {
        const newConfiguration = {
          ...localConfig,
          [key]: {
            ...entry,
            value
          }
        };
        setLocalConfig(newConfiguration);
      }
      setConfigView({
        ...configView,
        advancedConfigurations: configView.advancedConfigurations.map(config => config.key === key ? {
          ...config,
          value
        } : config)
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-connector-configuration-cancelEdit",
    isDisabled: isLoading,
    onClick: () => {
      cancelEditing();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.cancelEditingButton.title', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-configuration-saveConfiguration",
    "data-telemetry-id": "entSearchContent-connector-configuration-saveConfiguration",
    type: "submit",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.submitButton.title', {
    defaultMessage: 'Save'
  }))), saveAndSync && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-configuration-saveConfiguration",
    "data-telemetry-id": "entSearchContent-connector-configuration-saveConfiguration",
    isLoading: isLoading,
    fill: true,
    onClick: () => {
      saveAndSync(configViewToConfigValues(configView));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.submitButton.title', {
    defaultMessage: 'Save and sync'
  }))))));
};
exports.ConnectorConfigurationForm = ConnectorConfigurationForm;