"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchStorage = void 0;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _content_management = require("../../common/content_management");
var _cm_services = require("./schema/cm_services");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SavedSearchStorage extends _contentManagementUtils.SOContentStorage {
  constructor({
    logger,
    throwOnResultValidationError
  }) {
    super({
      savedObjectType: _content_management.SavedSearchType,
      cmServicesDefinition: _cm_services.cmServicesDefinition,
      enableMSearch: true,
      allowedSavedObjectAttributes: ['title', 'sort', 'columns', 'description', 'grid', 'hideChart', 'isTextBasedQuery', 'usesAdHocDataView', 'controlGroupJson', 'kibanaSavedObjectMeta', 'viewMode', 'hideAggregatedPreview', 'rowHeight', 'headerRowHeight', 'timeRestore', 'timeRange', 'refreshInterval', 'rowsPerPage', 'breakdownField', 'sampleSize', 'density', 'visContext', 'tabs'],
      logger,
      throwOnResultValidationError
    });
  }
  savedObjectToItem(savedObject, partial) {
    var _so$attributes$tabs;
    if (partial) {
      return super.savedObjectToItem(savedObject, true);
    }
    const so = super.savedObjectToItem(savedObject);

    // Despite our saved object transforms and what the types indicate,
    // we can still end up with Discover sessions without tabs that were
    // imported directly through the deprecated saved object APIs.
    // This is a backfill to ensure that any saved object we return
    // always has tabs. Ideally it can be removed once Core addresses
    // the issue at the saved objects API level.
    if (!((_so$attributes$tabs = so.attributes.tabs) !== null && _so$attributes$tabs !== void 0 && _so$attributes$tabs.length)) {
      so.attributes = (0, _common.extractTabs)(so.attributes, so.id);
    }
    return so;
  }
}
exports.SavedSearchStorage = SavedSearchStorage;