"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _tag_badge = require("./tag_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/components/base/tag_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Displays a list of tag
 */
const TagList = ({
  tags,
  onClick,
  tagRender
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, tags.map(tag => tagRender ? /*#__PURE__*/_react.default.createElement("span", {
    key: tag.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 11
    }
  }, tagRender(tag)) : /*#__PURE__*/_react.default.createElement(_tag_badge.TagBadge, {
    key: tag.name,
    tag: tag,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 11
    }
  })));
};
exports.TagList = TagList;