"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _objects_table = require("./objects_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/saved_objects_table_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const SavedObjectsTablePage = ({
  coreStart,
  dataStart,
  dataViewsApi,
  taggingApi,
  spacesApi,
  allowedTypes,
  actionRegistry,
  columnRegistry,
  setBreadcrumbs
}) => {
  const capabilities = coreStart.application.capabilities;
  const itemsPerPage = coreStart.uiSettings.get('savedObjects:perPage', 50);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const initialQuery = (0, _react.useMemo)(() => {
    const query = (0, _queryString.parse)(search);
    try {
      var _ref;
      return _eui.Query.parse((_ref = query.initialQuery) !== null && _ref !== void 0 ? _ref : '');
    } catch (e) {
      return _eui.Query.parse('');
    }
  }, [search]);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: _i18n.i18n.translate('savedObjectsManagement.breadcrumb.index', {
        defaultMessage: 'Saved objects'
      })
    }]);
  }, [setBreadcrumbs]);
  const ContextWrapper = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  return /*#__PURE__*/_react.default.createElement(ContextWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_objects_table.SavedObjectsTable, {
    initialQuery: initialQuery,
    allowedTypes: allowedTypes,
    actionRegistry: actionRegistry,
    columnRegistry: columnRegistry,
    taggingApi: taggingApi,
    dataViews: dataViewsApi,
    search: dataStart.search,
    http: coreStart.http,
    overlays: coreStart.overlays,
    notifications: coreStart.notifications,
    applications: coreStart.application,
    perPageConfig: itemsPerPage,
    goInspectObject: savedObject => {
      const savedObjectEditUrl = savedObject.meta.editUrl ? `/app${savedObject.meta.editUrl}` : `/app/management/kibana/objects/${savedObject.type}/${savedObject.id}`;
      coreStart.application.navigateToUrl(coreStart.http.basePath.prepend(savedObjectEditUrl));
    },
    canGoInApp: savedObject => {
      const {
        inAppUrl
      } = savedObject.meta;
      if (!inAppUrl) return false;
      if (!inAppUrl.uiCapabilitiesPath) return true;
      return Boolean((0, _lodash.get)(capabilities, inAppUrl.uiCapabilitiesPath));
    },
    customBranding: coreStart.customBranding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }));
};
// eslint-disable-next-line import/no-default-export
exports.default = SavedObjectsTablePage;
module.exports = exports.default;