"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JOB_DETAILS_TABS = exports.DetailPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("../../../../../common");
var _services = require("../../../services");
var _kibana_services = require("../../../../kibana_services");
var _components = require("../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_list/detail_panel/detail_panel.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JOB_DETAILS_TABS = exports.JOB_DETAILS_TABS = [_components.JOB_DETAILS_TAB_SUMMARY, _components.JOB_DETAILS_TAB_TERMS, _components.JOB_DETAILS_TAB_HISTOGRAM, _components.JOB_DETAILS_TAB_METRICS, _components.JOB_DETAILS_TAB_JSON];
const tabToUiMetricMap = {
  [_components.JOB_DETAILS_TAB_SUMMARY]: _common.UIM_DETAIL_PANEL_SUMMARY_TAB_CLICK,
  [_components.JOB_DETAILS_TAB_TERMS]: _common.UIM_DETAIL_PANEL_TERMS_TAB_CLICK,
  [_components.JOB_DETAILS_TAB_HISTOGRAM]: _common.UIM_DETAIL_PANEL_HISTOGRAM_TAB_CLICK,
  [_components.JOB_DETAILS_TAB_METRICS]: _common.UIM_DETAIL_PANEL_METRICS_TAB_CLICK,
  [_components.JOB_DETAILS_TAB_JSON]: _common.UIM_DETAIL_PANEL_JSON_TAB_CLICK
};
class DetailPanel extends _react.Component {
  constructor(props) {
    super(props);
  }
  renderTabs() {
    const {
      panelType,
      job,
      openDetailPanel
    } = this.props;
    if (!job) {
      return;
    }
    const {
      id,
      terms,
      histogram,
      metrics
    } = job;
    const renderedTabs = [];
    JOB_DETAILS_TABS.map((tab, index) => {
      if (tab === _components.JOB_DETAILS_TAB_TERMS && !terms.length) {
        return;
      }
      if (tab === _components.JOB_DETAILS_TAB_HISTOGRAM && !histogram.length) {
        return;
      }
      if (tab === _components.JOB_DETAILS_TAB_METRICS && !metrics.length) {
        return;
      }
      const isSelected = tab === panelType;
      renderedTabs.push(/*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        onClick: () => {
          (0, _kibana_services.trackUiMetric)(_services.METRIC_TYPE.CLICK, tabToUiMetricMap[tab]);
          openDetailPanel({
            panelType: tab,
            jobId: id
          });
        },
        isSelected: isSelected,
        "data-test-subj": `detailPanelTab${isSelected ? 'Selected' : ''}`,
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 9
        }
      }, _components.tabToHumanizedMap[tab]));
    });
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }, renderedTabs));
  }
  renderJob() {
    const {
      panelType,
      job
    } = this.props;
    const {
      status,
      documentsProcessed,
      pagesProcessed,
      rollupsIndexed,
      triggerCount,
      json
    } = job;
    const stats = {
      status,
      documentsProcessed,
      pagesProcessed,
      rollupsIndexed,
      triggerCount
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      "data-test-subj": "rollupJobDetailTabContent",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_components.JobDetails, {
      tab: panelType,
      job: job,
      stats: stats,
      json: json,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_components.JobActionMenu, {
      iconSide: "left",
      jobs: [job],
      anchorPosition: "upRight",
      detailPanel: true,
      iconType: "arrowUp",
      label: _i18n.i18n.translate('xpack.rollupJobs.detailPanel.jobActionMenu.buttonLabel', {
        defaultMessage: 'Manage'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    })))));
  }
  render() {
    const {
      isOpen,
      isLoading,
      closeDetailPanel,
      job,
      jobId
    } = this.props;
    if (!isOpen) {
      return null;
    }
    let content;
    if (isLoading) {
      content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
        "data-test-subj": "rollupJobDetailLoading",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        alignItems: "center",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.detailPanel.loadingLabel",
        defaultMessage: "Loading rollup job\u2026",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 19
        }
      }))))));
    } else if (job) {
      content = this.renderJob();
    } else {
      content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
        "data-test-subj": "rollupJobDetailJobNotFound",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        alignItems: "center",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.detailPanel.notFoundLabel",
        defaultMessage: "Rollup job not found",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 19
        }
      }))))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      "data-test-subj": "rollupJobDetailFlyout",
      onClose: closeDetailPanel,
      "aria-labelledby": "rollupJobDetailsFlyoutTitle",
      size: "m",
      maxWidth: 550,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      id: "rollupJobDetailsFlyoutTitle",
      "data-test-subj": "rollupJobDetailsFlyoutTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 13
      }
    }, jobId)), this.renderTabs()), content);
  }
}
exports.DetailPanel = DetailPanel;
(0, _defineProperty2.default)(DetailPanel, "propTypes", {
  isOpen: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool,
  job: _propTypes.default.object,
  jobId: _propTypes.default.string,
  panelType: _propTypes.default.oneOf(JOB_DETAILS_TABS),
  closeDetailPanel: _propTypes.default.func.isRequired,
  openDetailPanel: _propTypes.default.func.isRequired
});
(0, _defineProperty2.default)(DetailPanel, "defaultProps", {
  panelType: JOB_DETAILS_TABS[0]
});