"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelHoverActionsWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react2 = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _presentation_panel_hover_actions = require("./presentation_panel_hover_actions");
var _use_hover_actions_styles = require("./use_hover_actions_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/presentation_panel/public/panel_component/panel_header/presentation_panel_hover_actions_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const customActionsStyles = (0, _react2.css)({
  justifyContent: 'right !important',
  '.embPanel__hoverActionsAnchor &': {
    '&.embPanel__hoverActions': {
      visibility: 'visible !important',
      '& > * ': {
        padding: 0 // overrides --paddingAroundAction because the custom component can define their own paddings
      }
    }
  }
});
const PresentationPanelHoverActionsWrapper = props => {
  var _props$api, _props$api2, _props$api3, _props$api4, _props$api6;
  const [defaultTitle, title, hasLockedHoverActions, overrideHoverActions] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)((_props$api = props.api) === null || _props$api === void 0 ? void 0 : _props$api.defaultTitle$, (_props$api2 = props.api) === null || _props$api2 === void 0 ? void 0 : _props$api2.title$, (_props$api3 = props.api) === null || _props$api3 === void 0 ? void 0 : _props$api3.hasLockedHoverActions$, (_props$api4 = props.api) === null || _props$api4 === void 0 ? void 0 : _props$api4.overrideHoverActions$);
  const containerStyles = (0, _use_hover_actions_styles.useHoverActionStyles)(props.viewMode === 'edit', props.showBorder);
  let OverriddenHoverActionsComponent = null;
  if ((0, _presentationPublishing.canOverrideHoverActions)(props.api) && overrideHoverActions) {
    var _props$api5;
    OverriddenHoverActionsComponent = (_props$api5 = props.api) === null || _props$api5 === void 0 ? void 0 : _props$api5.OverriddenHoverActionsComponent;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('embPanel__hoverActionsAnchor', {
      'embPanel__hoverActionsAnchor--lockHoverActions': hasLockedHoverActions || Boolean(OverriddenHoverActionsComponent),
      'embPanel__hoverActionsAnchor--editMode': props.viewMode === 'edit'
    }),
    "data-test-embeddable-id": (_props$api6 = props.api) === null || _props$api6 === void 0 ? void 0 : _props$api6.uuid,
    "data-test-subj": `embeddablePanelHoverActions-${(title || defaultTitle || '').replace(/\s/g, '')}`,
    css: containerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, OverriddenHoverActionsComponent ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "embPanel__hoverActions",
    css: customActionsStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(OverriddenHoverActionsComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  })), props.children) : /*#__PURE__*/_react.default.createElement(_presentation_panel_hover_actions.PresentationPanelHoverActions, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  })));
};
exports.PresentationPanelHoverActionsWrapper = PresentationPanelHoverActionsWrapper;