"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewResultsInDiscoverAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _kibana = require("../common/lib/kibana");
var _use_logs_data_view = require("../common/hooks/use_logs_data_view");
var _pack_queries_status_table = require("../live_queries/form/pack_queries_status_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/discover/view_results_in_discover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ViewResultsInDiscoverActionComponent = ({
  actionId,
  buttonType,
  endDate,
  startDate
}) => {
  const {
    discover,
    application
  } = (0, _kibana.useKibana)().services;
  const locator = discover === null || discover === void 0 ? void 0 : discover.locator;
  const discoverPermissions = application.capabilities.discover_v2;
  const {
    data: logsDataView
  } = (0, _use_logs_data_view.useLogsDataView)({
    skip: !actionId,
    checkOnly: true
  });
  const [discoverUrl, setDiscoverUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const getDiscoverUrl = async () => {
      if (!locator || !logsDataView) return;
      const newUrl = await locator.getUrl({
        indexPatternId: logsDataView.id,
        filters: [{
          meta: {
            index: logsDataView.id,
            alias: null,
            negate: false,
            disabled: false,
            type: 'phrase',
            key: 'action_id',
            params: {
              query: actionId
            }
          },
          query: {
            match_phrase: {
              action_id: actionId
            }
          },
          $state: {
            store: _esQuery.FilterStateStore.APP_STATE
          }
        }],
        refreshInterval: {
          pause: true,
          value: 0
        },
        timeRange: startDate && endDate ? {
          to: endDate,
          from: startDate,
          mode: 'absolute'
        } : {
          to: 'now',
          from: 'now-1d',
          mode: 'relative'
        }
      });
      setDiscoverUrl(newUrl);
    };
    getDiscoverUrl();
  }, [actionId, endDate, startDate, locator, logsDataView]);
  if (!discoverPermissions.show) {
    return null;
  }
  if (buttonType === _pack_queries_status_table.ViewResultsActionButtonType.button) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "discoverApp",
      href: discoverUrl,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    }, VIEW_IN_DISCOVER);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_IN_DISCOVER,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "discoverApp",
    "aria-label": VIEW_IN_DISCOVER,
    href: discoverUrl,
    target: "_blank",
    isDisabled: !actionId || !discoverUrl.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }));
};
const VIEW_IN_DISCOVER = _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewDiscoverResultsActionAriaLabel', {
  defaultMessage: 'View in Discover'
});
const ViewResultsInDiscoverAction = exports.ViewResultsInDiscoverAction = /*#__PURE__*/_react.default.memo(ViewResultsInDiscoverActionComponent);