"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackViewInDiscoverAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _use_pack_query_last_results = require("../packs/use_pack_query_last_results");
var _pack_queries_status_table = require("../live_queries/form/pack_queries_status_table");
var _view_results_in_discover = require("./view_results_in_discover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/discover/pack_view_in_discover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PackViewInDiscoverActionComponent = ({
  item
}) => {
  const {
    action_id: actionId,
    interval
  } = item;
  const {
    data: lastResultsData
  } = (0, _use_pack_query_last_results.usePackQueryLastResults)({
    actionId,
    interval
  });
  const startDate = lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'] ? (0, _momentTimezone.default)(lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'][0]).subtract(interval, 'seconds').toISOString() : `now-${interval}s`;
  const endDate = lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'] ? (0, _momentTimezone.default)(lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'][0]).toISOString() : 'now';
  return /*#__PURE__*/_react.default.createElement(_view_results_in_discover.ViewResultsInDiscoverAction, {
    actionId: actionId,
    buttonType: _pack_queries_status_table.ViewResultsActionButtonType.icon,
    startDate: startDate,
    endDate: endDate,
    mode: lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'][0] ? 'absolute' : 'relative',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
};
const PackViewInDiscoverAction = exports.PackViewInDiscoverAction = /*#__PURE__*/_react.default.memo(PackViewInDiscoverActionComponent);