"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryAppEmptyState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _kibana = require("../common/lib/kibana");
var _osquery_icon = require("./osquery_icon");
var _use_breadcrumbs = require("../common/hooks/use_breadcrumbs");
var _common2 = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/components/empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OsqueryAppEmptyStateComponent = () => {
  (0, _use_breadcrumbs.useBreadcrumbs)('base');
  const {
    application: {
      getUrlForApp,
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const integrationHref = (0, _react.useMemo)(() => getUrlForApp(_common.INTEGRATIONS_PLUGIN_ID, {
    path: _public.pagePathGetters.integration_details_overview({
      pkgkey: _common2.OSQUERY_INTEGRATION_NAME
    })[1]
  }), [getUrlForApp]);
  const integrationClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      return navigateToApp(_common.INTEGRATIONS_PLUGIN_ID, {
        path: _public.pagePathGetters.integration_details_overview({
          pkgkey: _common2.OSQUERY_INTEGRATION_NAME
        })[1]
      });
    }
  }, [navigateToApp]);
  const pageHeader = (0, _react.useMemo)(() => ({
    iconType: _osquery_icon.OsqueryIcon,
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.emptyState.pageTitle",
      defaultMessage: "Add Osquery Manager",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.emptyState.pageDescription",
      defaultMessage: "Add this integration to run and schedule queries for Elastic Agent.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }),
    rightSideItems: [
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiButton, {
      key: "button",
      fill: true,
      href: integrationHref,
      onClick: integrationClick,
      iconType: "plusInCircleFilled",
      "data-test-subj": "osquery-add-integration-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.emptyState.addOsqueryManagerButton",
      defaultMessage: "Add Osquery Manager",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }))]
  }), [integrationClick, integrationHref]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    isEmptyState: true,
    pageHeader: pageHeader,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 10
    }
  });
};
const OsqueryAppEmptyState = exports.OsqueryAppEmptyState = /*#__PURE__*/_react.default.memo(OsqueryAppEmptyStateComponent);