"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformIndexSearchToolToFormData = exports.transformIndexSearchFormDataForUpdate = exports.transformIndexSearchFormDataForCreate = exports.transformFormDataToIndexSearchTool = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformIndexSearchToolToFormData = tool => {
  return {
    toolId: tool.id,
    description: tool.description,
    pattern: tool.configuration.pattern,
    labels: tool.tags,
    type: _onechatCommon.ToolType.index_search
  };
};
exports.transformIndexSearchToolToFormData = transformIndexSearchToolToFormData;
const transformFormDataToIndexSearchTool = data => {
  return {
    id: data.toolId,
    description: data.description,
    readonly: false,
    configuration: {
      pattern: data.pattern
    },
    type: _onechatCommon.ToolType.index_search,
    tags: data.labels
  };
};
exports.transformFormDataToIndexSearchTool = transformFormDataToIndexSearchTool;
const transformIndexSearchFormDataForCreate = data => {
  return (0, _lodash.omit)(transformFormDataToIndexSearchTool(data), ['readonly']);
};
exports.transformIndexSearchFormDataForCreate = transformIndexSearchFormDataForCreate;
const transformIndexSearchFormDataForUpdate = data => {
  return (0, _lodash.omit)(transformFormDataToIndexSearchTool(data), ['id', 'type', 'readonly']);
};
exports.transformIndexSearchFormDataForUpdate = transformIndexSearchFormDataForUpdate;