"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolTestFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _onechatBrowser = require("@kbn/onechat-browser");
var _react2 = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _doc_links = require("../../../../../common/doc_links");
var _use_execute_tools = require("../../../hooks/tools/use_execute_tools");
var _use_tools = require("../../../hooks/tools/use_tools");
var _tool_form = require("../form/tool_form");
var _i18n2 = require("../../../utils/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/execute/test_tools.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const flyoutStyles = (0, _react.css)`
  .euiFlyoutBody__overflowContent {
    height: 100%;
  }
`;
const flyoutContentStyles = (0, _react.css)`
  height: 100%;
`;
const inputsColumnStyles = (0, _react.css)`
  overflow-y: auto;
`;
const submitButtonContainerStyles = (0, _react.css)`
  align-self: flex-end;
`;
const i18nMessages = {
  fieldRequiredError: label => _i18n.i18n.translate('xpack.onechat.tools.testTool.fieldRequiredError', {
    defaultMessage: '{label} is required',
    values: {
      label
    }
  }),
  inputPlaceholder: label => _i18n.i18n.translate('xpack.onechat.tools.testTool.inputPlaceholder', {
    defaultMessage: 'Enter {label}',
    values: {
      label
    }
  }),
  title: _i18n.i18n.translate('xpack.onechat.tools.testFlyout.title', {
    defaultMessage: 'Test Tool'
  }),
  inputsTitle: _i18n.i18n.translate('xpack.onechat.tools.testTool.inputsTitle', {
    defaultMessage: 'Inputs'
  }),
  executeButton: _i18n.i18n.translate('xpack.onechat.tools.testTool.executeButton', {
    defaultMessage: 'Submit'
  }),
  responseTitle: _i18n.i18n.translate('xpack.onechat.tools.testTool.responseTitle', {
    defaultMessage: 'Response'
  })
};
var ToolParameterType = /*#__PURE__*/function (ToolParameterType) {
  ToolParameterType["TEXT"] = "text";
  ToolParameterType["NUMERIC"] = "numeric";
  ToolParameterType["BOOLEAN"] = "boolean";
  return ToolParameterType;
}(ToolParameterType || {});
const getComponentType = schemaType => {
  switch (schemaType) {
    case 'boolean':
      return ToolParameterType.BOOLEAN;
    case 'integer':
    case 'long':
    case 'number':
    case 'double':
    case 'float':
      return ToolParameterType.NUMERIC;
    default:
      return ToolParameterType.TEXT;
  }
};
const getParameters = tool => {
  var _tool$schema;
  if (!(tool !== null && tool !== void 0 && (_tool$schema = tool.schema) !== null && _tool$schema !== void 0 && _tool$schema.properties)) return [];
  const {
    properties,
    required
  } = tool.schema;
  const requiredParams = new Set(required);
  return Object.entries(properties).map(([paramName, paramSchema]) => {
    let type = 'string'; // default fallback

    if (paramSchema && 'type' in paramSchema && paramSchema.type) {
      if (Array.isArray(paramSchema.type)) {
        type = paramSchema.type[0];
      } else if (typeof paramSchema.type === 'string') {
        type = paramSchema.type;
      }
    }
    return {
      name: paramName,
      label: (paramSchema === null || paramSchema === void 0 ? void 0 : paramSchema.title) || paramName,
      value: '',
      description: (paramSchema === null || paramSchema === void 0 ? void 0 : paramSchema.description) || '',
      type,
      optional: !requiredParams.has(paramName)
    };
  });
};
const renderFormField = ({
  parameter,
  control
}) => {
  const {
    label,
    name,
    optional,
    type
  } = parameter;
  const componentType = getComponentType(type);
  const commonProps = {
    name,
    control,
    rules: {
      required: !optional ? i18nMessages.fieldRequiredError(parameter.label) : false
    }
  };
  switch (componentType) {
    case ToolParameterType.NUMERIC:
      return /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, (0, _extends2.default)({}, commonProps, {
        render: ({
          field: {
            onChange,
            value,
            ref,
            ...field
          }
        }) => {
          var _ref;
          return /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
            inputRef: ref,
            value: (_ref = value) !== null && _ref !== void 0 ? _ref : '',
            type: "number",
            onChange: e => onChange(e.target.valueAsNumber || e.target.value),
            placeholder: i18nMessages.inputPlaceholder(label),
            fullWidth: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 168,
              columnNumber: 13
            }
          }));
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 9
        }
      }));
    case ToolParameterType.BOOLEAN:
      return /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, (0, _extends2.default)({}, commonProps, {
        rules: {
          required: false
        },
        render: ({
          field: {
            onChange,
            value,
            ref,
            ...field
          }
        }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, field, {
          checked: Boolean(value),
          onChange: e => onChange(e.target.checked),
          label: label,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 187,
            columnNumber: 13
          }
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 9
        }
      }));
    case ToolParameterType.TEXT:
    default:
      return /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, (0, _extends2.default)({}, commonProps, {
        render: ({
          field: {
            value,
            ref,
            ...field
          }
        }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, field, {
          inputRef: ref,
          value: value,
          placeholder: i18nMessages.inputPlaceholder(label),
          fullWidth: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 203,
            columnNumber: 13
          }
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 9
        }
      }));
  }
};
const ToolTestFlyout = ({
  toolId,
  onClose,
  formMode
}) => {
  const isSmallScreen = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm']);
  const [response, setResponse] = (0, _react2.useState)('{}');
  // Re-mount new responses, needed for virtualized EuiCodeBlock
  // https://github.com/elastic/eui/issues/9034
  const [responseKey, setResponseKey] = (0, _react2.useState)(0);
  const form = (0, _reactHookForm.useForm)({
    mode: 'onChange'
  });
  const {
    handleSubmit,
    control,
    formState: {
      errors
    }
  } = form;
  const hasErrors = Object.keys(errors).length > 0;
  const {
    tool,
    isLoading
  } = (0, _use_tools.useTool)({
    toolId
  });
  const {
    executeTool,
    isLoading: isExecuting
  } = (0, _use_execute_tools.useExecuteTool)({
    onSuccess: data => {
      setResponse(JSON.stringify(data, null, 2));
    },
    onError: error => {
      setResponse(JSON.stringify({
        error: (0, _onechatBrowser.formatOnechatErrorMessage)(error)
      }, null, 2));
    },
    onSettled: () => {
      setResponseKey(key => key + 1);
    }
  });
  const onSubmit = async formData => {
    await executeTool({
      toolId: tool.id,
      toolParams: formData
    });
  };
  if (!tool) return null;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": "flyoutTitle",
    css: flyoutStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    id: "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 15
    }
  }, i18nMessages.title))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: `${_doc_links.docLinks.tools}#testing-your-tools`,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.onechat.tools.testFlyout.documentationLink', {
    defaultMessage: 'Documentation - Testing tools'
  }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }, isLoading ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react2.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, form, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: isSmallScreen ? 'm' : 'l',
    direction: isSmallScreen ? 'column' : 'row',
    css: flyoutContentStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: inputsColumnStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 19
    }
  }, i18nMessages.inputsTitle)), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: handleSubmit(onSubmit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 19
    }
  }, getParameters(tool).map(parameter => {
    var _errors$name;
    const {
      name,
      label,
      description,
      optional
    } = parameter;
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
      key: name,
      label: label,
      labelAppend: optional && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 310,
          columnNumber: 31
        }
      }, _i18n2.labels.common.optional),
      helpText: description,
      isInvalid: !!errors[name],
      error: (_errors$name = errors[name]) === null || _errors$name === void 0 ? void 0 : _errors$name.message,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 25
      }
    }, renderFormField({
      parameter,
      control
    }));
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: !isSmallScreen && submitButtonContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    type: "submit",
    iconType: "sortRight",
    isLoading: isExecuting,
    disabled: !tool || hasErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 23
    }
  }, i18nMessages.executeButton))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 19
    }
  }, i18nMessages.responseTitle)), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    key: responseKey,
    language: "json",
    fontSize: "s",
    paddingSize: "m",
    isCopyable: true,
    lineNumbers: true,
    isVirtualized: true,
    overflowHeight: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 17
    }
  }, response))))), formMode === _tool_form.ToolFormMode.Edit && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n2.labels.tools.testTool.backToEditToolButton,
    iconType: "sortLeft",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 11
    }
  }, _i18n2.labels.tools.testTool.backToEditToolButton)));
};
exports.ToolTestFlyout = ToolTestFlyout;