"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextMenuItemsFromActions = getContextMenuItemsFromActions;
var _public = require("@kbn/ui-actions-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getContextMenuItemsFromActions({
  uiActions,
  triggerId,
  context
}) {
  return uiActions.getTriggerCompatibleActions(triggerId, context).then(actions => {
    return (0, _public.buildContextMenuForActions)({
      actions: actions.map(action => ({
        action,
        trigger: {
          id: triggerId
        },
        context
      }))
    });
  }).then(descriptors => {
    return descriptors.flatMap(descriptor => {
      var _descriptor$items;
      return (_descriptor$items = descriptor.items) !== null && _descriptor$items !== void 0 ? _descriptor$items : [];
    }).map(item => {
      return {
        ...item,
        children: item.children || item.name
      };
    });
  });
}