"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsSection = AlertsSection;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_has_data = require("../../../../../hooks/use_has_data");
var _section_container = require("../section_container");
var _paths = require("../../../../../../common/locators/paths");
var _constants = require("../../../../../../common/constants");
var _alerts_table = require("../../../../../components/alerts_table/alerts_table");
var _alert_summary_widget = require("../../../../../utils/alert_summary_widget");
var _use_date_picker_context = require("../../../../../hooks/use_date_picker_context");
var _get_columns = require("../../../../../components/alerts_table/common/get_columns");
var _kibana_react = require("../../../../../utils/kibana_react");
var _constants2 = require("../../../../../constants");
var _build_es_query = require("../../../../../utils/build_es_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/alerts/alerts_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERTS_PER_PAGE = 10;
const ALERTS_TABLE_ID = 'xpack.observability.overview.alert.table';
const tableColumns = (0, _get_columns.getColumns)({
  showRuleName: true
});
function AlertsSection({
  bucketSize
}) {
  var _hasDataMap$alert;
  const {
    http,
    triggersActionsUi: {
      getAlertSummaryWidget: AlertSummaryWidget
    },
    data,
    notifications,
    fieldFormats,
    application,
    licensing,
    cases,
    settings
  } = (0, _kibana_react.useKibana)().services;
  const {
    relativeStart,
    relativeEnd
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const {
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const esQuery = (0, _react.useMemo)(() => (0, _build_es_query.buildEsQuery)({
    timeRange: {
      from: relativeStart,
      to: relativeEnd
    }
  }), [relativeStart, relativeEnd]);
  const alertSummaryTimeRange = (0, _react.useMemo)(() => (0, _alert_summary_widget.getAlertSummaryTimeRange)({
    from: relativeStart,
    to: relativeEnd
  }, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.intervalString) || _constants2.DEFAULT_INTERVAL, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) || _constants2.DEFAULT_DATE_FORMAT), [bucketSize, relativeEnd, relativeStart]);
  if (!((_hasDataMap$alert = hasDataMap.alert) !== null && _hasDataMap$alert !== void 0 && _hasDataMap$alert.hasData)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_section_container.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.alerts.title', {
      defaultMessage: 'Alerts'
    }),
    "data-test-subj": "obltOverviewAlerts",
    appLink: {
      href: _paths.paths.observability.alerts,
      label: _i18n.i18n.translate('xpack.observability.overview.alerts.appLink', {
        defaultMessage: 'Show alerts'
      })
    },
    hasError: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: _constants.observabilityAlertFeatureIds,
    filter: esQuery,
    fullSize: true,
    timeRange: alertSummaryTimeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_alerts_table.ObservabilityAlertsTable, {
    id: ALERTS_TABLE_ID,
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: _constants.observabilityAlertFeatureIds,
    query: esQuery,
    pageSize: ALERTS_PER_PAGE,
    columns: tableColumns,
    showInspectButton: true,
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      licensing,
      cases,
      settings
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
}