"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationForm = AnnotationForm;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
var _annotation_apply_to = require("./components/annotation_apply_to");
var _forward_refs = require("./components/forward_refs");
var _annotation_range = require("./components/annotation_range");
var _annotation_apearance = require("./annotation_apearance");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/annotation_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AnnotationForm({
  editAnnotation
}) {
  var _formState$errors$mes, _formState$errors$mes2, _formState$errors$mes3, _formState$errors$mes4;
  const {
    control,
    formState,
    watch,
    unregister,
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const timestampStart = watch('@timestamp');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: "annotationForm",
    component: "form",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_annotation_range.AnnotationRange, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "event.end",
    control: control,
    render: ({
      field: {
        value,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_forward_refs.Switch, (0, _extends2.default)({}, field, {
      label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.applyAsRangeLabel', {
        defaultMessage: 'Apply as range'
      }),
      checked: Boolean(value),
      onChange: evt => {
        if (evt.target.checked) {
          field.onChange(timestampStart);
        } else {
          // we need to do this to avoid validation errors
          unregister('event.end');
          field.onChange(null);
          setValue('annotation.style.color', _eventAnnotationCommon.defaultAnnotationColor);
        }
      },
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.titleLabel', {
      defaultMessage: 'Title'
    }),
    display: "columnCompressed",
    fullWidth: true,
    error: (_formState$errors$mes = formState.errors.message) === null || _formState$errors$mes === void 0 ? void 0 : _formState$errors$mes.message,
    isInvalid: Boolean((_formState$errors$mes2 = formState.errors.message) === null || _formState$errors$mes2 === void 0 ? void 0 : _formState$errors$mes2.message),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: "annotation.title",
    control: control,
    rules: {
      required: 'title is required'
    },
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_forward_refs.FieldText, (0, _extends2.default)({}, field, {
      isInvalid: fieldState.invalid,
      compressed: true,
      "data-test-subj": "annotationTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    display: "columnCompressed",
    fullWidth: true,
    error: (_formState$errors$mes3 = formState.errors.message) === null || _formState$errors$mes3 === void 0 ? void 0 : _formState$errors$mes3.message,
    isInvalid: Boolean((_formState$errors$mes4 = formState.errors.message) === null || _formState$errors$mes4 === void 0 ? void 0 : _formState$errors$mes4.message),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: "message",
    control: control,
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_forward_refs.TextArea, (0, _extends2.default)({}, field, {
      rows: 3,
      isInvalid: fieldState.invalid,
      compressed: true,
      "data-test-subj": "annotationMessage",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.tagsLabel', {
      defaultMessage: 'Tags'
    }),
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: [],
    name: "tags",
    control: control,
    render: ({
      field
    }) => {
      var _field$value, _field$value2;
      return /*#__PURE__*/_react.default.createElement(_forward_refs.ComboBox, (0, _extends2.default)({}, field, {
        options: (_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.map(tag => ({
          label: tag
        })),
        selectedOptions: (_field$value2 = field.value) === null || _field$value2 === void 0 ? void 0 : _field$value2.map(tag => ({
          label: tag
        })),
        onChange: val => {
          field.onChange(val.map(option => option.label));
        },
        onCreateOption: searchValue => {
          var _field$value3;
          field.onChange([...((_field$value3 = field.value) !== null && _field$value3 !== void 0 ? _field$value3 : []), searchValue]);
        },
        isClearable: true,
        compressed: true,
        "data-test-subj": "annotationTags",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 13
        }
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_annotation_apearance.AnnotationAppearance, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_annotation_apply_to.AnnotationApplyTo, {
    editAnnotation: editAnnotation,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }));
}