"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElserModelId = getElserModelId;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getElserModelId({
  core,
  logger
}) {
  const defaultModelId = '.elser_model_2';
  const [_, pluginsStart] = await core.getStartServices();

  // Wait for the license to be available so the ML plugin's guards pass once we ask for ELSER stats
  const license = await (0, _rxjs.firstValueFrom)(pluginsStart.licensing.license$);
  if (!license.hasAtLeast('enterprise')) {
    return defaultModelId;
  }
  try {
    // Wait for the ML plugin's dependency on the internal saved objects client to be ready
    const {
      ml
    } = await core.plugins.onSetup('ml');
    if (!ml.found) {
      throw new Error('Could not find ML plugin');
    }
    const elserModelDefinition = await ml.contract.trainedModelsProvider({}, {}) // request, savedObjectsClient (but we fake it to use the internal user)
    .getELSER();
    return elserModelDefinition.model_id;
  } catch (error) {
    logger.error(`Failed to resolve ELSER model definition: ${error}`);
    return defaultModelId;
  }
}