"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _rule_connector = require("../../common/rule_connector");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/rule_connector/ai_assistant.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getConnectorType(service) {
  return {
    id: _rule_connector.OBSERVABILITY_AI_ASSISTANT_CONNECTOR_ID,
    modalWidth: 675,
    iconClass: () => /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 22
      }
    }),
    isSystemActionType: true,
    isExperimental: true,
    selectMessage: _translations.CONNECTOR_DESC,
    actionTypeTitle: _translations.CONNECTOR_TITLE,
    validateParams: async actionParams => {
      var _actionParams$prompts;
      const validatePrompt = prompt => {
        const errors = [];
        if (!prompt.message) {
          errors.push(_translations.MESSAGE_REQUIRED);
        }
        if ((0, _lodash.isEmpty)(prompt.statuses)) {
          errors.push(_translations.STATUS_REQUIRED);
        }
        return errors;
      };
      return {
        errors: {
          connector: actionParams.connector ? [] : [_translations.CONNECTOR_REQUIRED],
          message: actionParams.message && !actionParams.prompts ? [_translations.MESSAGE_REQUIRED] : [],
          prompts: ((_actionParams$prompts = actionParams.prompts) === null || _actionParams$prompts === void 0 ? void 0 : _actionParams$prompts.map(validatePrompt)) || []
        }
      };
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./ai_assistant_params'))).then(({
      default: ActionParamsFields
    }) => ({
      default: props => /*#__PURE__*/_react.default.createElement(ActionParamsFields, (0, _extends2.default)({}, props, {
        service: service,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 29
        }
      }))
    }))),
    actionConnectorFields: null
  };
}