"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationViewWithProps = ConversationViewWithProps;
var _react = _interopRequireDefault(require("react"));
var _aiAssistant = require("@kbn/ai-assistant");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _use_observability_ai_assistant_params = require("../../hooks/use_observability_ai_assistant_params");
var _use_observability_ai_assistant_router = require("../../hooks/use_observability_ai_assistant_router");
var _use_local_storage = require("../../hooks/use_local_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/routes/conversations/conversation_view_with_props.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ConversationViewWithProps() {
  const {
    path
  } = (0, _use_observability_ai_assistant_params.useObservabilityAIAssistantParams)('/conversations/*');
  const conversationId = 'conversationId' in path ? path.conversationId : undefined;
  const observabilityAIAssistantRouter = (0, _use_observability_ai_assistant_router.useObservabilityAIAssistantRouter)();
  const [flyoutSettings] = (0, _use_local_storage.useLocalStorage)('observabilityAIAssistant.flyoutSettings', {
    mode: _aiAssistant.FlyoutPositionMode.OVERLAY,
    isOpen: false
  });
  function navigateToConversation(nextConversationId) {
    if (nextConversationId) {
      observabilityAIAssistantRouter.push('/conversations/{conversationId}', {
        path: {
          conversationId: nextConversationId
        },
        query: {}
      });
    } else {
      observabilityAIAssistantRouter.push('/conversations/new', {
        path: {},
        query: {}
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_public.ObservabilityAIAssistantFlyoutStateProvider, {
    isFlyoutOpen: flyoutSettings.isOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_aiAssistant.ConversationView, {
    conversationId: conversationId,
    navigateToConversation: navigateToConversation,
    newConversationHref: observabilityAIAssistantRouter.link('/conversations/new'),
    getConversationHref: id => observabilityAIAssistantRouter.link(`/conversations/{conversationId}`, {
      path: {
        conversationId: id
      }
    }),
    scopes: ['observability'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }));
}