"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Legacy = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Legacy {
  static init({
    core,
    data,
    isCloud,
    cloudBaseUrl,
    hasEnterpriseLicense,
    triggersActionsUi,
    usageCollection,
    appMountParameters
  }) {
    this._shims = {
      toastNotifications: core.notifications.toasts,
      capabilities: core.application.capabilities,
      getBasePath: () => core.http.basePath.get(),
      breadcrumbs: {
        set: breadcrumbs => this._shims.breadcrumbs.update(breadcrumbs),
        update: breadcrumbs => {
          var _breadcrumbs, _breadcrumbs$0$href;
          if (!breadcrumbs) {
            var _core$chrome$getBread;
            const currentBreadcrumbs = (_core$chrome$getBread = core.chrome.getBreadcrumbs$()) === null || _core$chrome$getBread === void 0 ? void 0 : _core$chrome$getBread.source;
            breadcrumbs = currentBreadcrumbs === null || currentBreadcrumbs === void 0 ? void 0 : currentBreadcrumbs.value;
          }
          const globalStateStr = location.hash.split('?')[1];
          if (!((_breadcrumbs = breadcrumbs) !== null && _breadcrumbs !== void 0 && _breadcrumbs.length) || (globalStateStr === null || globalStateStr === void 0 ? void 0 : globalStateStr.indexOf('_g')) !== 0 || ((_breadcrumbs$0$href = breadcrumbs[0].href) === null || _breadcrumbs$0$href === void 0 ? void 0 : _breadcrumbs$0$href.split('?')[1]) === globalStateStr) {
            return;
          }
          breadcrumbs.forEach(breadcrumb => {
            var _breadcrumb$href;
            const breadcrumbHref = (_breadcrumb$href = breadcrumb.href) === null || _breadcrumb$href === void 0 ? void 0 : _breadcrumb$href.split('?')[0];
            if (breadcrumbHref && !breadcrumb.ignoreGlobalState) {
              breadcrumb.href = `${breadcrumbHref}?${globalStateStr}`;
            }
            delete breadcrumb.ignoreGlobalState;
          });
          core.chrome.setBreadcrumbs(breadcrumbs.slice(0));
        }
      },
      I18nContext: core.i18n.Context,
      docLinks: core.docLinks,
      docTitle: core.chrome.docTitle,
      timefilter: data.query.timefilter.timefilter,
      actionTypeRegistry: triggersActionsUi === null || triggersActionsUi === void 0 ? void 0 : triggersActionsUi.actionTypeRegistry,
      ruleTypeRegistry: triggersActionsUi === null || triggersActionsUi === void 0 ? void 0 : triggersActionsUi.ruleTypeRegistry,
      uiSettings: core.uiSettings,
      http: core.http,
      kfetch: async ({
        pathname,
        ...options
      }, kfetchOptions) => await core.http.fetch(pathname, {
        prependBasePath: kfetchOptions === null || kfetchOptions === void 0 ? void 0 : kfetchOptions.prependBasePath,
        ...options
      }),
      isCloud,
      cloudBaseUrl,
      hasEnterpriseLicense,
      triggersActionsUi,
      usageCollection,
      kibanaServices: {
        ...core,
        usageCollection
      },
      appMountParameters
    };
  }
  static get shims() {
    if (!Legacy._shims) {
      throw new Error('Legacy needs to be initiated with Legacy.init(...) before use');
    }
    return Legacy._shims;
  }
  static isInitializated() {
    return Boolean(Legacy._shims);
  }
}
exports.Legacy = Legacy;
(0, _defineProperty2.default)(Legacy, "_shims", void 0);