"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Listing = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _format_number = require("../../../lib/format_number");
var _cluster_status = require("../cluster_status");
var _table = require("../../table");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _badge = require("../../setup_mode/badge");
var _listing_callout = require("../../setup_mode/listing_callout");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _status = require("../../../alerts/status");
var _setup_mode = require("../../../lib/setup_mode");
var _enums = require("../../../../common/enums");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/listing/listing.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Listing extends _react.PureComponent {
  getColumns() {
    const setupMode = this.props.setupMode;
    const alerts = this.props.alerts;
    return [{
      name: _i18n.i18n.translate('xpack.monitoring.logstash.nodes.nameTitle', {
        defaultMessage: 'Name'
      }),
      field: 'name',
      sortable: true,
      render: (name, node) => {
        let setupModeStatus = null;
        if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
          const list = (0, _lodash.get)(setupMode, 'data.byUuid', {});
          const uuid = (0, _lodash.get)(node, 'logstash.uuid');
          const status = list[uuid] || {};
          const instance = {
            uuid,
            name: node.name
          };
          setupModeStatus = /*#__PURE__*/_react.default.createElement(_badge.SetupModeBadge, {
            setupMode: setupMode,
            status: status,
            instance: instance,
            productName: _constants.LOGSTASH_SYSTEM_ID,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 55,
              columnNumber: 15
            }
          });
        }
        return /*#__PURE__*/_react.default.createElement("div", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "name",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/logstash/node/${node.logstash.uuid}`),
          "data-test-subj": `nodeLink-${node.logstash.uuid}`,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 17
          }
        }, name)), /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "httpAddress",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 15
          }
        }, node.logstash.http_address), setupModeStatus);
      }
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.nodes.alertsColumnTitle', {
        defaultMessage: 'Alerts'
      }),
      field: 'isOnline',
      width: '175px',
      sortable: true,
      render: () => /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
        showBadge: true,
        alerts: alerts,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 23
        }
      })
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.nodes.cpuUsageTitle', {
        defaultMessage: 'CPU Usage'
      }),
      field: 'cpu_usage',
      sortable: true,
      render: value => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "cpuUsage",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 11
        }
      }, (0, _format_number.formatPercentageUsage)(value, 100))
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.nodes.loadAverageTitle', {
        defaultMessage: 'Load Average'
      }),
      field: 'load_average',
      sortable: true,
      render: value => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "loadAverage",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 28
        }
      }, (0, _format_number.formatNumber)(value, '0.00'))
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.nodes.jvmHeapUsedTitle', {
        defaultMessage: '{javaVirtualMachine} Heap Used',
        values: {
          javaVirtualMachine: 'JVM'
        }
      }),
      field: 'jvm_heap_used',
      sortable: true,
      render: value => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "jvmHeapUsed",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 11
        }
      }, (0, _format_number.formatPercentageUsage)(value, 100))
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.nodes.eventsIngestedTitle', {
        defaultMessage: 'Events Ingested'
      }),
      field: 'events_out',
      sortable: true,
      render: value => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eventsOut",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 28
        }
      }, (0, _format_number.formatNumber)(value, '0.[0]a'))
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.nodes.configReloadsTitle', {
        defaultMessage: 'Config Reloads'
      }),
      sortable: true,
      render: node => /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "configReloadsSuccess",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.logstash.nodes.configReloadsSuccessCountLabel",
        defaultMessage: "{reloadsSuccesses} successes",
        values: {
          reloadsSuccesses: node.reloads.successes
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "configReloadsFailure",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.logstash.nodes.configReloadsFailuresCountLabel",
        defaultMessage: "{reloadsFailures} failures",
        values: {
          reloadsFailures: node.reloads.failures
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 15
        }
      })))
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.nodes.versionTitle', {
        defaultMessage: 'Version'
      }),
      field: 'version',
      sortable: true,
      render: value => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "version",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 28
        }
      }, (0, _format_number.formatNumber)(value))
    }];
  }
  render() {
    const {
      stats,
      alerts,
      sorting,
      pagination,
      onTableChange,
      data,
      setupMode
    } = this.props;
    const columns = this.getColumns();
    const flattenedData = data.map(item => ({
      ...item,
      name: (0, _lodash.get)(item, 'logstash.name', 'N/A'),
      cpu_usage: (0, _lodash.get)(item, 'process.cpu.percent', 'N/A'),
      load_average: (0, _lodash.get)(item, 'os.cpu.load_average.1m', 'N/A'),
      jvm_heap_used: (0, _lodash.get)(item, 'jvm.mem.heap_used_percent', 'N/A'),
      events_out: (0, _lodash.get)(item, 'events.out', 'N/A'),
      version: (0, _lodash.get)(item, 'logstash.version', 'N/A')
    }));
    let setupModeCallOut = null;
    if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
      setupModeCallOut = /*#__PURE__*/_react.default.createElement(_listing_callout.ListingCallOut, {
        setupModeData: setupMode.data,
        useNodeIdentifier: true,
        productName: _constants.LOGSTASH_SYSTEM_ID,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logstash.instances.heading",
      defaultMessage: "Logstash instances",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_cluster_status.ClusterStatus, {
      stats: stats,
      alerts: alerts,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 11
      }
    }), setupModeCallOut, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
      "data-test-subj": "logstashNodesTable",
      rows: flattenedData,
      setupMode: setupMode,
      productName: _constants.LOGSTASH_SYSTEM_ID,
      columns: columns,
      sorting: {
        ...sorting,
        sort: {
          ...sorting.sort,
          field: 'name'
        }
      },
      pagination: pagination,
      search: {
        box: {
          incremental: true,
          placeholder: _i18n.i18n.translate('xpack.monitoring.logstash.filterNodesPlaceholder', {
            defaultMessage: 'Filter Nodes…'
          })
        }
      },
      onTableChange: onTableChange,
      executeQueryOptions: {
        defaultFields: ['name']
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 13
      }
    }))));
  }
}
exports.Listing = Listing;