"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Status = Status;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _summary_status = require("../../summary_status");
var _status_icon = require("../status_icon");
var _format_number = require("../../../lib/format_number");
var _common = require("../../../../common");
var _constants = require("../../../../common/constants");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/apm/instances/status.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Status({
  alerts,
  stats
}) {
  const {
    apms: {
      total
    },
    totalEvents,
    timeOfLastEvent
  } = stats;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.apm.instances.status.serversLabel', {
      defaultMessage: 'Servers'
    }),
    value: total,
    'data-test-subj': 'total'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.apm.instances.status.totalEventsLabel', {
      defaultMessage: 'Total Events'
    }),
    value: (0, _format_number.formatMetric)(totalEvents, '0.[0]a'),
    'data-test-subj': 'totalEvents'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.apm.instances.status.lastEventLabel', {
      defaultMessage: 'Last Event'
    }),
    value: _i18n.i18n.translate('xpack.monitoring.apm.instances.status.lastEventDescription', {
      defaultMessage: '{timeOfLastEvent} ago',
      values: {
        timeOfLastEvent: (0, _common.formatTimestampToDuration)(+(0, _moment.default)(timeOfLastEvent), _constants.CALCULATE_DURATION_SINCE)
      }
    }),
    'data-test-subj': 'timeOfLastEvent'
  }];
  const IconComponent = ({
    status
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.apm.instances.statusDescription",
    defaultMessage: "Status: {apmStatusIcon}",
    values: {
      apmStatusIcon: /*#__PURE__*/_react.default.createElement(_status_icon.ApmStatusIcon, {
        status: status,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 26
        }
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    alerts: alerts,
    IconComponent: IconComponent,
    "data-test-subj": "apmDetailStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  });
}