"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineVersions = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/logstash/pipeline_versions_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PipelineVersions = props => {
  const {
    pipelineHash,
    pipelineVersions,
    onChangePipelineHash
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: pipelineHash,
    options: pipelineVersions.map(option => {
      return {
        text: _i18n.i18n.translate('xpack.monitoring.logstashNavigation.pipelineVersionDescription', {
          defaultMessage: 'Version active {relativeLastSeen} and first seen {relativeFirstSeen}',
          values: {
            relativeLastSeen: option.relativeLastSeen,
            relativeFirstSeen: option.relativeFirstSeen
          }
        }),
        value: option.hash
      };
    }),
    onChange: ({
      target
    }) => onChangePipelineHash(target.value),
    "aria-label": _i18n.i18n.translate('xpack.monitoring.logstashNavigation.pipelineVersionSelectLabel', {
      defaultMessage: 'Pipeline version'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 9
    }
  })));
};
exports.PipelineVersions = PipelineVersions;