"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalStateProvider = exports.GlobalStateContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _url_state = require("../../url_state");
var _legacy_shims = require("../../legacy_shims");
var _should_override_refresh_interval = require("./should_override_refresh_interval");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/contexts/global_state_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GlobalStateContext = exports.GlobalStateContext = /*#__PURE__*/(0, _react.createContext)({});
const REFRESH_INTERVAL_OVERRIDE = {
  pause: false,
  value: 10000
};
const GlobalStateProvider = ({
  uiSettings,
  query,
  toasts,
  children
}) => {
  const localState = {};
  const [globalState] = (0, _react.useState)(() => new _url_state.GlobalState(query, toasts, localState));
  const initialState = globalState.getState();
  for (const key in initialState) {
    if (!Object.hasOwn(initialState, key)) {
      continue;
    }
    localState[key] = initialState[key];
  }
  localState.save = () => {
    const newState = {
      ...localState
    };
    delete newState.save;
    globalState.setState(newState);
  };

  // default to an active refresh interval if it's not conflicting with user-defined values
  if ((0, _should_override_refresh_interval.shouldOverrideRefreshInterval)(uiSettings, _legacy_shims.Legacy.shims.timefilter)) {
    localState.refreshInterval = REFRESH_INTERVAL_OVERRIDE;
    _legacy_shims.Legacy.shims.timefilter.setRefreshInterval(localState.refreshInterval);
    localState.save();
  }
  (0, _useUnmount.default)(() => {
    globalState.destroy();
  });
  return /*#__PURE__*/_react.default.createElement(GlobalStateContext.Provider, {
    value: localState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 10
    }
  }, children);
};
exports.GlobalStateProvider = GlobalStateProvider;