"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsDropdown = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_alerts_modal = require("../application/hooks/use_alerts_modal");
var _enable_alerts_modal = require("./enable_alerts_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/alerts_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertsDropdown = () => {
  const [shouldShowModal, setShouldShowModal] = (0, _react.useState)(false);
  const alertsEnableModalProvider = (0, _use_alerts_modal.useAlertsModal)();
  const {
    navigateToApp
  } = (0, _public.useKibana)().services.application;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const togglePopoverVisibility = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const createDefaultRules = () => {
    setShouldShowModal(true);
  };
  const createButtonClick = () => {
    alertsEnableModalProvider.enableAlerts();
    closeModal();
  };
  const closeModal = () => {
    setShouldShowModal(false);
    closePopover();
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: 'right',
    iconType: 'arrowDown',
    onClick: togglePopoverVisibility,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.dropdown.button",
    defaultMessage: "Alerts and rules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
  const items = [{
    name: _i18n.i18n.translate('xpack.monitoring.alerts.dropdown.createAlerts', {
      defaultMessage: 'Create default rules'
    }),
    onClick: createDefaultRules
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.alerts.dropdown.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    icon: 'tableOfContents',
    onClick: () => navigateToApp('management', {
      path: '/insightsAndAlerting/triggersActions/rules'
    })
  }];
  const panels = [{
    id: 0,
    title: _i18n.i18n.translate('xpack.monitoring.alerts.dropdown.title', {
      defaultMessage: 'Alerts and rules'
    }),
    items
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  })), shouldShowModal ? /*#__PURE__*/_react.default.createElement(_enable_alerts_modal.WatcherMigrationStep, {
    closeModal: closeModal,
    createButtonClick: createButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }) : null);
};
exports.AlertsDropdown = AlertsDropdown;