"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressIcon = ProgressIcon;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _progress_states = require("./progress_states");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/forecasting_modal/progress_icon.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Icon representing the progress of a running forecast.
 */
function ProgressIcon({
  state
}) {
  if (state === _progress_states.PROGRESS_STATES.WAITING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 12
      }
    });
  } else if (state === _progress_states.PROGRESS_STATES.DONE) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      size: "m",
      color: "primary",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 12
      }
    });
  } else if (state === _progress_states.PROGRESS_STATES.ERROR) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      size: "m",
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 12
      }
    });
  }
}
ProgressIcon.propTypes = {
  state: _propTypes.default.number
};