"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexESQLBasedRouteFactory = exports.indexBasedRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _breadcrumbs = require("../../breadcrumbs");
var _ml = require("../../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/datavisualizer/index_based.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Page = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../datavisualizer/index_based/index_data_visualizer')))).IndexDataVisualizerPage
}));
const indexBasedRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_view_datavisualizer',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER),
  title: _i18n.i18n.translate('xpack.ml.dataVisualizer.dataView.docTitle', {
    defaultMessage: 'Index Data Visualizer'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, {
    esql: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 17
    }
  }),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_VISUALIZER_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsBreadcrumbs.dataViewLabel', {
      defaultMessage: 'Data View'
    })
  }]
});
exports.indexBasedRouteFactory = indexBasedRouteFactory;
const indexESQLBasedRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_view_datavisualizer_esql',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_ESQL),
  title: _i18n.i18n.translate('xpack.ml.dataVisualizer.esql.docTitle', {
    defaultMessage: 'Index Data Visualizer (ES|QL)'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, {
    esql: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 17
    }
  }),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_VISUALIZER_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsBreadcrumbs.esqlLabel', {
      defaultMessage: 'Index Data Visualizer (ES|QL)'
    })
  }]
});
exports.indexESQLBasedRouteFactory = indexESQLBasedRouteFactory;
const PageWrapper = ({
  esql
}) => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('basic', []);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Page, {
    esql: esql,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
};