"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataVizIndexOrSearchRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _navigate_to_page_button = require("../components/navigate_to_page_button");
var _breadcrumbs = require("../breadcrumbs");
var _locator = require("../../../locator");
var _router = require("../router");
var _index_or_search_page_wrapper = require("./new_job/index_or_search_page_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/data_view_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDataVisBreadcrumbs = (navigateToPath, basePath) => [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_VISUALIZER_BREADCRUMB', navigateToPath, basePath), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.selectDateViewLabel', {
    defaultMessage: 'Select Data View'
  })
}];
const dataVizIndexOrSearchRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_view_datavisualizer',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_INDEX_SELECT),
  title: _i18n.i18n.translate('xpack.ml.selectDataViewLabel', {
    defaultMessage: 'Select Data View'
  }),
  render: (props, deps) => {
    const button = /*#__PURE__*/_react.default.createElement(_navigate_to_page_button.NavigateToPageButton, {
      nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_ESQL),
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.datavisualizer.selector.useESQLButtonLabel",
        defaultMessage: "Use ES|QL",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_index_or_search_page_wrapper.PageWrapper, (0, _extends2.default)({}, props, {
      nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER),
      deps: deps,
      mode: _index_or_search_page_wrapper.MODE.DATAVISUALIZER,
      extraButtons: button,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    }));
  },
  breadcrumbs: getDataVisBreadcrumbs(navigateToPath, basePath)
});
exports.dataVizIndexOrSearchRouteFactory = dataVizIndexOrSearchRouteFactory;