"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiMetricDetectorsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _settings = require("../../../charts/common/settings");
var _chart_grid = require("./chart_grid");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/multi_metric_view/metric_selection_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultiMetricDetectorsSummary = () => {
  const uiSettings = (0, _kibana.useUiSettings)();
  const {
    jobCreator: jc,
    chartLoader,
    resultsLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const [lineChartsData, setLineChartsData] = (0, _react.useState)({});
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [modelData, setModelData] = (0, _react.useState)([]);
  const [anomalyData, setAnomalyData] = (0, _react.useState)([]);
  const [chartSettings, setChartSettings] = (0, _react.useState)(_settings.defaultChartSettings);
  const [fieldValues, setFieldValues] = (0, _react.useState)([]);
  function setResultsWrapper(results) {
    setModelData(results.model);
    setAnomalyData(results.anomalies);
  }
  (0, _react.useEffect)(() => {
    // subscribe to progress and results
    const subscription = resultsLoader.subscribeToResults(setResultsWrapper);
    (async () => {
      if (jobCreator.splitField !== null) {
        try {
          const tempFieldValues = await chartLoader.loadFieldExampleValues(jobCreator.splitField, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options);
          setFieldValues(tempFieldValues);
        } catch (error) {
          toastNotificationService.displayErrorToast(error);
        }
      }
    })();
    return () => {
      subscription.unsubscribe();
    };
    // skip toastNotificationService from deps
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartLoader, resultsLoader, jobCreator]);
  (0, _react.useEffect)(() => {
    if (allDataReady()) {
      loadCharts();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fieldValues]);
  async function loadCharts() {
    if (allDataReady()) {
      setLoadingData(true);
      try {
        const cs = (0, _settings.getChartSettings)(uiSettings, jobCreator, chartInterval);
        setChartSettings(cs);
        const resp = await chartLoader.loadLineCharts(jobCreator.start, jobCreator.end, jobCreator.aggFieldPairs, jobCreator.splitField, fieldValues.length > 0 ? fieldValues[0] : null, cs.intervalMs, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options);
        setLineChartsData(resp);
      } catch (error) {
        toastNotificationService.displayErrorToast(error);
        setLineChartsData({});
      }
      setLoadingData(false);
    }
  }
  function allDataReady() {
    return jobCreator.aggFieldPairs.length > 0 && (jobCreator.splitField === null || jobCreator.splitField !== null && fieldValues.length > 0);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, Object.keys(lineChartsData).length && /*#__PURE__*/_react.default.createElement(_chart_grid.ChartGrid, {
    aggFieldPairList: jobCreator.aggFieldPairs,
    chartSettings: chartSettings,
    splitField: jobCreator.splitField,
    fieldValues: fieldValues,
    lineChartsData: lineChartsData,
    modelData: modelData,
    anomalyData: anomalyData,
    deleteDetector: undefined,
    jobType: jobCreator.type,
    loading: loadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }));
};
exports.MultiMetricDetectorsSummary = MultiMetricDetectorsSummary;