"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoDetectorsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _job_creator_context = require("../../../job_creator_context");
var _kibana = require("../../../../../../../contexts/kibana");
var _geo_map_examples = require("./geo_map_examples");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/geo_view/metric_selection_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GeoDetectorsSummary = () => {
  const [layerList, setLayerList] = (0, _react.useState)([]);
  const [fieldValues, setFieldValues] = (0, _react.useState)([]);
  const {
    jobCreator: jc,
    chartLoader,
    mapLoader
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const geoField = jobCreator.geoField;
  const splitField = jobCreator.splitField;
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useMlKibana)();

  // Load example field values for summary view
  // changes to fieldValues here will trigger the card effect
  (0, _react.useEffect)(() => {
    if (splitField !== null) {
      chartLoader.loadFieldExampleValues(splitField, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options).then(setFieldValues).catch(error => {
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.ml.newJob.geoWizard.fieldValuesFetchErrorTitle', {
            defaultMessage: 'Error fetching field example values: {error}',
            values: {
              error
            }
          })
        });
      });
    } else {
      setFieldValues([]);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // Update the layer list once the example fields have been
  (0, _react.useEffect)(() => {
    async function getMapLayersForGeoJob() {
      if (geoField) {
        var _jobCreator$savedSear;
        const {
          query
        } = (_jobCreator$savedSear = jobCreator.savedSearchQuery) !== null && _jobCreator$savedSear !== void 0 ? _jobCreator$savedSear : {};
        const layers = await mapLoader.getMapLayersForGeoJob(geoField, splitField, fieldValues, query);
        setLayerList(layers);
      }
    }
    getMapLayersForGeoJob();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fieldValues]);
  if (jobCreator.geoField === null) return null;
  return /*#__PURE__*/_react.default.createElement(_geo_map_examples.GeoMapExamples, {
    geoField: jobCreator.geoField,
    splitField: jobCreator.splitField,
    fieldValues: fieldValues,
    geoAgg: jobCreator.geoAgg,
    layerList: layerList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
exports.GeoDetectorsSummary = GeoDetectorsSummary;