"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteJobModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_focus_restoration = require("../../../../util/create_focus_restoration");
var _kibana = require("../../../../contexts/kibana");
var _utils = require("../utils");
var _jobs_list = require("../../../../../../common/constants/jobs_list");
var _delete_space_aware_item_check_modal = require("../../../../components/delete_space_aware_item_check_modal");
var _jobs_utils = require("../../../jobs_utils");
var _managed_jobs_warning_callout = require("../confirm_modals/managed_jobs_warning_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/delete_job_modal/delete_job_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteJobModal = ({
  setShowFunction,
  unsetShowFunction,
  refreshJobs
}) => {
  const {
    services: {
      notifications: {
        toasts
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const [deleting, setDeleting] = (0, _react.useState)(false);
  const [modalVisible, setModalVisible] = (0, _react.useState)(false);
  const [adJobs, setAdJobs] = (0, _react.useState)([]);
  const [canDelete, setCanDelete] = (0, _react.useState)(false);
  const [deleteUserAnnotations, setDeleteUserAnnotations] = (0, _react.useState)(false);
  const [deleteAlertingRules, setDeleteAlertingRules] = (0, _react.useState)(false);
  const deleteJobModalTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    if (typeof setShowFunction === 'function') {
      setShowFunction(showModal);
    }
    return () => {
      if (typeof unsetShowFunction === 'function') {
        unsetShowFunction();
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const showModal = (0, _react.useCallback)(jobs => {
    setAdJobs(jobs);
    setModalVisible(true);
    setDeleting(false);
    setDeleteUserAnnotations(false);
  }, []);
  const {
    jobIds,
    hasManagedJob,
    hasAlertingRules
  } = (0, _react.useMemo)(() => {
    return {
      jobIds: adJobs.map(({
        id
      }) => id),
      hasManagedJob: adJobs.some(job => (0, _jobs_utils.isManagedJob)(job)),
      hasAlertingRules: adJobs.some(job => Array.isArray(job.alertingRules) && job.alertingRules.length > 0)
    };
  }, [adJobs]);
  const closeModal = (0, _react.useCallback)(() => {
    setModalVisible(false);
    setCanDelete(false);
    // Manually return focus to the delete job action button
    // This is a workaround to fix the issue where the focus is not returned to the action button when the modal is closed
    if (jobIds.length === 1) {
      (0, _create_focus_restoration.createJobActionFocusRestoration)(jobIds[0])();
    }
  }, [jobIds]);
  const deleteJob = (0, _react.useCallback)(() => {
    setDeleting(true);
    (0, _utils.deleteJobs)(toasts, mlApi, jobIds.map(id => ({
      id
    })), deleteUserAnnotations, deleteAlertingRules);
    setTimeout(() => {
      closeModal();
      refreshJobs();
    }, _jobs_list.BLOCKED_JOBS_REFRESH_INTERVAL_MS);
  }, [toasts, mlApi, jobIds, deleteUserAnnotations, deleteAlertingRules, closeModal, refreshJobs]);
  if (modalVisible === false || jobIds.length === 0) {
    return null;
  }
  if (canDelete) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "aria-labelledby": deleteJobModalTitleId,
      "data-test-subj": "mlDeleteJobConfirmModal",
      onClose: closeModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: deleteJobModalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteJobsTitle",
      defaultMessage: "Delete {jobsCount, plural, one {{jobId}} other {# jobs}}?",
      values: {
        jobsCount: jobIds.length,
        jobId: jobIds[0]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }, deleting === true ? /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deletingJobsStatusLabel",
      defaultMessage: "Deleting jobs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasManagedJob ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
      jobsCount: jobIds.length,
      action: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobModal.deleteAction', {
        defaultMessage: 'deleting'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 21
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteMultipleJobsDescription",
      defaultMessage: "Deleting {jobsCount, plural, one {a job} other {multiple jobs}} can be time consuming. {jobsCount, plural, one {It} other {They}} will be deleted in the background and may not disappear from the jobs list instantly.",
      values: {
        jobsCount: jobIds.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobModal.deleteUserAnnotations', {
        defaultMessage: 'Delete annotations'
      }),
      checked: deleteUserAnnotations,
      onChange: e => setDeleteUserAnnotations(e.target.checked),
      "data-test-subj": "mlDeleteJobConfirmModalDeleteAnnotationsSwitch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 19
      }
    }), hasAlertingRules ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.ml.jobsList.resetJobModal.deleteAlertingRules', {
        defaultMessage: 'Delete alerting rules'
      }),
      checked: deleteAlertingRules,
      onChange: e => setDeleteAlertingRules(e.target.checked),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 23
      }
    })) : null)))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal,
      disabled: deleting,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: deleteJob,
      fill: true,
      disabled: deleting,
      color: "danger",
      "data-test-subj": "mlDeleteJobConfirmModalButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteButtonLabel",
      defaultMessage: "Delete",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 15
      }
    })))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_delete_space_aware_item_check_modal.DeleteSpaceAwareItemCheckModal, {
      ids: jobIds,
      mlSavedObjectType: "anomaly-detector",
      canDeleteCallback: () => {
        setCanDelete(true);
      },
      onCloseCallback: closeModal,
      refreshJobsCallback: refreshJobs,
      hasManagedJob: hasManagedJob,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 9
      }
    }));
  }
};
exports.DeleteJobModal = DeleteJobModal;