"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalysisFieldsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _custom_selection_table = require("../../../../../components/custom_selection_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/configuration_step/analysis_fields_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore could not find declaration file
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const minimumFieldsMessage = _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analysisFieldsTable.minimumFieldsMessage', {
  defaultMessage: 'At least one field must be selected.'
});
const checkboxDisabledCheck = item => item.is_required === true || item.reason && item.reason.includes('unsupported type');
const AnalysisFieldsTable = exports.AnalysisFieldsTable = /*#__PURE__*/_react.default.memo(({
  dependentVariable,
  includes,
  isJobTypeWithDepVar,
  setFormState,
  minimumFieldsRequiredMessage,
  setMinimumFieldsRequiredMessage,
  tableItems,
  unsupportedFieldsError,
  setUnsupportedFieldsError
}) => {
  const [sortableProperties, setSortableProperties] = (0, _react.useState)();
  const [currentPaginationData, setCurrentPaginationData] = (0, _react.useState)({
    pageIndex: 0,
    itemsPerPage: 5
  });
  const {
    handleFieldStatsButtonClick
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  const columns = [{
    id: 'checkbox',
    isCheckbox: true,
    textOnly: false,
    width: '32px'
  }, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analysisFieldsTable.fieldNameColumn', {
      defaultMessage: 'Field name'
    }),
    id: 'name',
    // eslint-disable-next-line @typescript-eslint/naming-convention
    render: ({
      name,
      mapping_types
    }) => {
      const field = {
        id: name,
        type: Array.isArray(mapping_types) && mapping_types.length > 0 ? mapping_types[0] : 'number'
      };
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.FieldStatsInfoButton, {
        field: field,
        label: name,
        onButtonClick: handleFieldStatsButtonClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 15
        }
      }));
    },
    isSortable: true,
    alignment: _eui.LEFT_ALIGNMENT
  }, {
    id: 'mapping_types',
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsTable.mappingColumn', {
      defaultMessage: 'Mapping'
    }),
    isSortable: false,
    alignment: _eui.LEFT_ALIGNMENT
  }, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsTable.isIncludedColumn', {
      defaultMessage: 'Is included'
    }),
    id: 'is_included',
    alignment: _eui.LEFT_ALIGNMENT,
    isSortable: true,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    render: ({
      is_included
    }) => is_included ? 'Yes' : 'No'
  }, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsTable.isRequiredColumn', {
      defaultMessage: 'Is required'
    }),
    id: 'is_required',
    alignment: _eui.LEFT_ALIGNMENT,
    isSortable: true,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    render: ({
      is_required
    }) => is_required ? 'Yes' : 'No'
  }, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsTable.reasonColumn', {
      defaultMessage: 'Reason'
    }),
    id: 'reason',
    alignment: _eui.LEFT_ALIGNMENT,
    isSortable: false
  }];
  (0, _react.useEffect)(() => {
    if (includes.length === 0 && tableItems.length > 0) {
      const includedFields = [];
      tableItems.forEach(field => {
        if (field.is_included === true) {
          includedFields.push(field.name);
        }
      });
      setFormState({
        includes: includedFields
      });
    } else if (includes.length > 0) {
      setFormState({
        includes: dependentVariable && includes.includes(dependentVariable) || !isJobTypeWithDepVar ? includes : [...includes, dependentVariable]
      });
    }
    setMinimumFieldsRequiredMessage(undefined);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tableItems]);
  (0, _react.useEffect)(() => {
    let sortablePropertyItems = [];
    const defaultSortProperty = 'name';
    sortablePropertyItems = [{
      name: 'name',
      getValue: item => item.name.toLowerCase(),
      isAscending: true
    }, {
      name: 'is_included',
      getValue: item => item.is_included,
      isAscending: true
    }, {
      name: 'is_required',
      getValue: item => item.is_required,
      isAscending: true
    }];
    const sortableProps = new _eui.SortableProperties(sortablePropertyItems, defaultSortProperty);
    setSortableProperties(sortableProps);
  }, []);
  const filters = [{
    type: 'field_value_toggle_group',
    field: 'is_included',
    items: [{
      value: true,
      name: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.isIncludedOption', {
        defaultMessage: 'Is included'
      })
    }, {
      value: false,
      name: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.isNotIncludedOption', {
        defaultMessage: 'Is not included'
      })
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "mlAnalyticsCreateJobWizardIncludesTable",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.includedFieldsLabel', {
      defaultMessage: 'Included fields'
    }),
    fullWidth: true,
    isInvalid: minimumFieldsRequiredMessage !== undefined || unsupportedFieldsError !== undefined,
    error: [...(minimumFieldsRequiredMessage !== undefined ? [minimumFieldsRequiredMessage] : []), ...(unsupportedFieldsError !== undefined ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.unsupportedFieldsError', {
      defaultMessage: 'Invalid. {message}',
      values: {
        message: unsupportedFieldsError
      }
    })] : [])],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  })), tableItems.length > 0 && minimumFieldsRequiredMessage === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.includedFieldsCount', {
    defaultMessage: '{numFields, plural, one {# field} other {# fields}} included in the analysis',
    values: {
      numFields: includes.length
    }
  })), tableItems.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.calloutTitle', {
      defaultMessage: 'Analysis fields not available'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.calloutMessage",
    defaultMessage: "Additional data required to load analysis fields.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  })), tableItems.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    "data-test-subj": "mlAnalyticsCreateJobWizardIncludesSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_selection_table.CustomSelectionTable, {
    currentPage: currentPaginationData.pageIndex,
    "data-test-subj": "mlAnalyticsCreationAnalysisFieldsTable",
    checkboxDisabledCheck: checkboxDisabledCheck,
    columns: columns,
    filters: filters,
    items: tableItems,
    itemsPerPage: currentPaginationData.itemsPerPage,
    onTableChange: selection => {
      // dependent variable must always be in includes
      if (isJobTypeWithDepVar && dependentVariable !== undefined && dependentVariable !== '' && selection.length === 0) {
        selection = [dependentVariable];
      }
      // If includes is empty show minimum fields required message and don't update form yet
      if (selection.length === 0) {
        setMinimumFieldsRequiredMessage(minimumFieldsMessage);
        setUnsupportedFieldsError(undefined);
      } else {
        setMinimumFieldsRequiredMessage(undefined);
        setFormState({
          includes: selection
        });
      }
    },
    selectedIds: includes,
    setCurrentPaginationData: setCurrentPaginationData,
    singleSelection: false,
    sortableProperties: sortableProperties,
    tableItemId: 'name',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 9
    }
  }));
}, (prevProps, nextProps) => {
  return prevProps.dependentVariable === nextProps.dependentVariable && (0, _lodash.isEqual)(prevProps.includes, nextProps.includes) && (0, _lodash.isEqual)(prevProps.tableItems, nextProps.tableItems) && prevProps.unsupportedFieldsError === nextProps.unsupportedFieldsError;
});