"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlNotificationsContextProvider = exports.MlNotificationsContext = void 0;
exports.useMlNotifications = useMlNotifications;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _moment = _interopRequireDefault(require("moment"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _kibana = require("../kibana");
var _storage = require("../../../../common/types/storage");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/contexts/ml/ml_notifications_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NOTIFICATIONS_CHECK_INTERVAL = 60000;
const defaultCounts = {
  info: 0,
  error: 0,
  warning: 0
};
const MlNotificationsContext = exports.MlNotificationsContext = /*#__PURE__*/_react.default.createContext({
  notificationsCounts: defaultCounts,
  lastCheckedAt: null,
  latestRequestedAt: null,
  setLastCheckedAt: () => {}
});
const MlNotificationsContextProvider = ({
  children
}) => {
  const {
    services: {
      mlServices: {
        mlApi
      },
      application: {
        capabilities
      }
    }
  } = (0, _kibana.useMlKibana)();
  const canGetJobs = capabilities.ml.canGetJobs;
  const canGetDataFrameAnalytics = capabilities.ml.canGetDataFrameAnalytics;
  const canGetTrainedModels = capabilities.ml.canGetTrainedModels;
  const canGetNotifications = canGetJobs && canGetDataFrameAnalytics && canGetTrainedModels;
  const [lastCheckedAt, setLastCheckedAt] = (0, _mlLocalStorage.useStorage)(_storage.ML_NOTIFICATIONS_LAST_CHECKED_AT);
  const lastCheckedAt$ = (0, _hooks.useAsObservable)(lastCheckedAt);

  /** Holds the value used for the actual request */
  const [latestRequestedAt, setLatestRequestedAt] = (0, _react.useState)(null);
  const [notificationsCounts, setNotificationsCounts] = (0, _react.useState)(defaultCounts);
  (0, _react.useEffect)(function startPollingNotifications() {
    if (!canGetNotifications) return;
    const subscription = (0, _rxjs.combineLatest)([lastCheckedAt$, (0, _rxjs.timer)(0, NOTIFICATIONS_CHECK_INTERVAL)]).pipe(
    // Use the latest check time or 7 days ago by default.
    (0, _rxjs.map)(([lastChecked]) => lastChecked !== null && lastChecked !== void 0 ? lastChecked : (0, _moment.default)().subtract(7, 'd').valueOf()), (0, _rxjs.tap)(lastCheckedAtQuery => {
      setLatestRequestedAt(lastCheckedAtQuery);
    }), (0, _rxjs.switchMap)(lastCheckedAtQuery => mlApi.notifications.countMessages$({
      lastCheckedAt: lastCheckedAtQuery
    })), (0, _rxjs.retry)({
      delay: NOTIFICATIONS_CHECK_INTERVAL
    })).subscribe(response => {
      setNotificationsCounts((0, _mlIsPopulatedObject.isPopulatedObject)(response) ? response : defaultCounts);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [canGetNotifications, lastCheckedAt$, mlApi.notifications]);
  return /*#__PURE__*/_react.default.createElement(MlNotificationsContext.Provider, {
    value: {
      notificationsCounts,
      lastCheckedAt,
      setLastCheckedAt,
      latestRequestedAt
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, children);
};
exports.MlNotificationsContextProvider = MlNotificationsContextProvider;
function useMlNotifications() {
  return (0, _react.useContext)(MlNotificationsContext);
}