"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _lodash = require("lodash");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _useLifecycles = _interopRequireDefault(require("react-use/lib/useLifecycles"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _storage = require("../../common/types/storage");
var _license = require("./license");
var _routing = require("./routing");
var _ml = require("./contexts/ml");
var _get_services = require("./util/get_services");
var _ml_telemetry_context = require("./contexts/ml/ml_telemetry_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const localStorage = new _public.Storage(window.localStorage);
const App = ({
  coreStart,
  deps,
  appMountParams,
  isServerless,
  mlFeatures,
  experimentalFeatures,
  nlpSettings,
  entryPoint
}) => {
  var _deps$usageCollection, _deps$usageCollection2;
  const pageDeps = {
    history: appMountParams.history,
    setHeaderActionMenu: (0, _mlIsPopulatedObject.isPopulatedObject)(appMountParams, ['setHeaderActionMenu']) ? appMountParams.setHeaderActionMenu : undefined,
    setBreadcrumbs: coreStart.chrome.setBreadcrumbs
  };
  const chromeStyle = (0, _useObservable.default)(coreStart.chrome.getChromeStyle$(), 'classic');
  const services = (0, _react.useMemo)(() => {
    return {
      ...coreStart,
      cases: deps.cases,
      charts: deps.charts,
      contentManagement: deps.contentManagement,
      dashboard: deps.dashboard,
      data: deps.data,
      dataViewEditor: deps.dataViewEditor,
      dataViews: deps.data.dataViews,
      dataVisualizer: deps.dataVisualizer,
      embeddable: deps.embeddable,
      fieldFormats: deps.fieldFormats,
      kibanaVersion: deps.kibanaVersion,
      lens: deps.lens,
      licensing: deps.licensing,
      licenseManagement: deps.licenseManagement,
      maps: deps.maps,
      observabilityAIAssistant: deps.observabilityAIAssistant,
      presentationUtil: deps.presentationUtil,
      savedObjectsManagement: deps.savedObjectsManagement,
      savedSearch: deps.savedSearch,
      security: deps.security,
      share: deps.share,
      storage: localStorage,
      triggersActionsUi: deps.triggersActionsUi,
      uiActions: deps.uiActions,
      unifiedSearch: deps.unifiedSearch,
      usageCollection: deps.usageCollection,
      mlServices: (0, _get_services.getMlGlobalServices)(coreStart, deps.data.dataViews, deps.usageCollection),
      spaces: deps.spaces,
      fieldsMetadata: deps.fieldsMetadata
    };
  }, [deps, coreStart]);
  (0, _useLifecycles.default)(function setupLicenseOnMount() {
    (0, _license.setLicenseCache)(services.mlServices.mlLicense);
    services.mlServices.mlLicense.setup(deps.licensing.license$);
  }, function destroyLicenseOnUnmount() {
    services.mlServices.mlLicense.unsubscribe();
  });

  // Wait for license and capabilities to be retrieved before rendering the app.
  const licenseReady = (0, _useObservable.default)(services.mlServices.mlLicense.isLicenseReady$, false);
  const mlCapabilities = (0, _useObservable.default)(services.mlServices.mlCapabilities.capabilities$, services.mlServices.mlCapabilities.getCapabilities());
  if (!licenseReady || !mlCapabilities) return null;
  const startServices = (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme', 'userProfile');
  const datePickerDeps = {
    ...(0, _lodash.pick)(services, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice: !isServerless
  };
  const ApplicationUsageTrackingProvider = (_deps$usageCollection = (_deps$usageCollection2 = deps.usageCollection) === null || _deps$usageCollection2 === void 0 ? void 0 : _deps$usageCollection2.components.ApplicationUsageTrackingProvider) !== null && _deps$usageCollection !== void 0 ? _deps$usageCollection : _react.default.Fragment;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.ML_STORAGE_KEYS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_ml.EnabledFeaturesContextProvider, {
    isServerless: isServerless,
    mlFeatures: mlFeatures,
    showMLNavMenu: chromeStyle === 'classic',
    experimentalFeatures: experimentalFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_ml.MlServerInfoContextProvider, {
    nlpSettings: nlpSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_telemetry_context.MlTelemetryContextProvider, {
    telemetryClient: deps.telemetry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_routing.MlRouter, {
    pageDeps: pageDeps,
    entryPoint: entryPoint,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 21
    }
  })))))))));
};
exports.App = App;
const renderApp = (coreStart, deps, appMountParams, isServerless, mlFeatures, experimentalFeatures, nlpSettings) => {
  appMountParams.onAppLeave(actions => actions.default());
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(App, {
    coreStart: coreStart,
    deps: deps,
    appMountParams: appMountParams,
    isServerless: isServerless,
    mlFeatures: mlFeatures,
    experimentalFeatures: experimentalFeatures,
    nlpSettings: nlpSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 5
    }
  }), appMountParams.element);
  return () => {
    _reactDom.default.unmountComponentAtNode(appMountParams.element);
    deps.data.search.session.clear();
  };
};
exports.renderApp = renderApp;