"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapApp = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _full_body_height_css = require("@kbn/css-utils/public/full_body_height_css");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _react2 = require("@emotion/react");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _managedContentBadge = require("@kbn/managed-content-badge");
var _kibana_services = require("../../../kibana_services");
var _url_state = require("../url_state");
var _map_container = require("../../../connected_components/map_container");
var _index_pattern_util = require("../../../index_pattern_util");
var _top_nav_config = require("../top_nav_config");
var _constants = require("../../../../common/constants");
var _saved_map = require("../saved_map");
var _wait_until_time_layers_load = require("./wait_until_time_layers_load");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/routes/map_page/map_app/map_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const styles = {
  wrapper: (0, _react2.css)([{
    display: 'flex',
    flexDirection: 'column'
  }, (0, _full_body_height_css.kbnFullBodyHeightCss)()]),
  fullScreen: (0, _react2.css)({
    height: '100vh !important'
  }),
  reactMapsRoot: (0, _react2.css)({
    flexGrow: 1,
    display: 'flex',
    flexDirection: 'column'
  })
};
class MapApp extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_autoRefreshSubscription", null);
    (0, _defineProperty2.default)(this, "_globalSyncUnsubscribe", null);
    (0, _defineProperty2.default)(this, "_globalSyncChangeMonitorSubscription", null);
    (0, _defineProperty2.default)(this, "_appSyncUnsubscribe", null);
    (0, _defineProperty2.default)(this, "_appStateManager", new _url_state.AppStateManager());
    (0, _defineProperty2.default)(this, "_prevIndexPatternIds", null);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_kbnUrlStateStorage", void 0);
    (0, _defineProperty2.default)(this, "_initialTimeFromUrl", void 0);
    (0, _defineProperty2.default)(this, "_updateFromGlobalState", ({
      changes,
      state: globalState
    }) => {
      if (!this.state.initialized || !changes || !globalState) {
        return;
      }
      this._onQueryChange({
        time: globalState.time
      });
    });
    (0, _defineProperty2.default)(this, "_onQueryChange", ({
      filters,
      query,
      time
    }) => {
      const {
        filterManager
      } = (0, _kibana_services.getData)().query;
      if (filters) {
        filterManager.setFilters(filters);
      }
      this.props.setQuery({
        forceRefresh: false,
        filters: filterManager.getFilters(),
        query,
        timeFilters: time
      });

      // sync appState
      this._appStateManager.setQueryAndFilters({
        filters: filterManager.getAppFilters(),
        query
      });

      // sync globalState
      const updatedGlobalState = {
        filters: filterManager.getGlobalFilters()
      };
      if (time) {
        updatedGlobalState.time = time;
      }
      this._updateGlobalState(updatedGlobalState);
    });
    (0, _defineProperty2.default)(this, "_onFiltersChange", filters => {
      this._onQueryChange({
        filters
      });
    });
    (0, _defineProperty2.default)(this, "_updateStateFromSavedQuery", savedQuery => {
      this.setState({
        savedQuery: {
          ...savedQuery
        }
      });
      this._appStateManager.setQueryAndFilters({
        savedQueryId: savedQuery.id
      });
      const {
        filterManager
      } = (0, _kibana_services.getData)().query;
      const savedQueryFilters = savedQuery.attributes.filters || [];
      const globalFilters = filterManager.getGlobalFilters();
      const allFilters = [...savedQueryFilters, ...globalFilters];
      const refreshInterval = _lodash.default.get(savedQuery, 'attributes.timefilter.refreshInterval');
      if (refreshInterval) {
        this._onRefreshConfigChange({
          isPaused: refreshInterval.pause,
          interval: refreshInterval.value
        });
      }
      this._onQueryChange({
        filters: allFilters,
        query: savedQuery.attributes.query,
        time: savedQuery.attributes.timefilter
      });
    });
    (0, _defineProperty2.default)(this, "_addFilter", async newFilters => {
      newFilters.forEach(filter => {
        filter.$state = {
          store: _esQuery.FilterStateStore.APP_STATE
        };
      });
      this._onFiltersChange([...this.props.filters, ...newFilters]);
    });
    this.state = {
      indexPatterns: [],
      initialized: false,
      isRefreshPaused: true,
      refreshInterval: 0
    };
    this._kbnUrlStateStorage = (0, _public2.createKbnUrlStateStorage)({
      useHash: false,
      history: props.history,
      ...(0, _public2.withNotifyOnErrors)((0, _kibana_services.getToasts)())
    });
  }
  componentDidMount() {
    var _this$_getGlobalState;
    this._isMounted = true;
    const executionContext = {
      type: 'application',
      name: _constants.APP_ID,
      url: window.location.pathname,
      id: this.props.savedMap.getSavedObjectId() || 'new',
      page: 'editor'
    };
    (0, _kibana_services.getExecutionContextService)().set(executionContext); // set execution context in core ExecutionContextStartService
    this.props.setExecutionContext(executionContext); // set execution context in redux store

    this._autoRefreshSubscription = (0, _kibana_services.getTimeFilter)().getAutoRefreshFetch$().pipe((0, _rxjs.tap)(() => {
      this.props.setQuery({
        forceRefresh: true
      });
    }), (0, _rxjs.switchMap)(done => (0, _wait_until_time_layers_load.waitUntilTimeLayersLoad$)(this.props.savedMap.getStore()).pipe((0, _rxjs.finalize)(done)))).subscribe();

    // syncGlobalQueryStateWithUrl mutates global state by merging URL state with Kibana QueryStart state
    // capture _initialTimeFromUrl before global state is mutated
    this._initialTimeFromUrl = (_this$_getGlobalState = this._getGlobalState()) === null || _this$_getGlobalState === void 0 ? void 0 : _this$_getGlobalState.time;
    const {
      stop
    } = (0, _public.syncGlobalQueryStateWithUrl)((0, _kibana_services.getData)().query, this._kbnUrlStateStorage);
    this._globalSyncUnsubscribe = stop;
    this._appSyncUnsubscribe = (0, _url_state.startAppStateSyncing)(this._appStateManager, this._kbnUrlStateStorage);
    this._globalSyncChangeMonitorSubscription = (0, _kibana_services.getData)().query.state$.subscribe(this._updateFromGlobalState);

    // savedQuery must be fetched from savedQueryId
    // const initialSavedQuery = this._appStateManager.getAppState().savedQuery;
    // if (initialSavedQuery) {
    //   this._updateStateFromSavedQuery(initialSavedQuery as SavedQuery);
    // }

    this._initMap();
    this.props.onAppLeave(actions => {
      if (this.props.savedMap.hasUnsavedChanges()) {
        return actions.confirm(_saved_map.unsavedChangesWarning, _saved_map.unsavedChangesTitle);
      }
      return actions.default();
    });
  }
  componentDidUpdate() {
    this._updateIndexPatterns();
  }
  componentWillUnmount() {
    this._isMounted = false;
    if (this._autoRefreshSubscription) {
      this._autoRefreshSubscription.unsubscribe();
    }
    if (this._globalSyncUnsubscribe) {
      this._globalSyncUnsubscribe();
    }
    if (this._appSyncUnsubscribe) {
      this._appSyncUnsubscribe();
    }
    if (this._globalSyncChangeMonitorSubscription) {
      this._globalSyncChangeMonitorSubscription.unsubscribe();
    }
    this.props.onAppLeave(actions => {
      return actions.default();
    });
  }
  _getGlobalState() {
    var _this$_kbnUrlStateSto;
    return (_this$_kbnUrlStateSto = this._kbnUrlStateStorage.get('_g')) !== null && _this$_kbnUrlStateSto !== void 0 ? _this$_kbnUrlStateSto : {};
  }
  _updateGlobalState(newState) {
    this._kbnUrlStateStorage.set('_g', {
      ...this._getGlobalState(),
      ...newState
    });
    if (!this.state.initialized) {
      this._kbnUrlStateStorage.kbnUrlControls.flush(true);
    }
  }
  async _updateIndexPatterns() {
    const {
      nextIndexPatternIds
    } = this.props;
    if (_lodash.default.isEqual(nextIndexPatternIds, this._prevIndexPatternIds)) {
      return;
    }
    this._prevIndexPatternIds = nextIndexPatternIds;
    let indexPatterns = [];
    if (nextIndexPatternIds.length === 0) {
      // Use default data view to always show filter bar when filters are present
      // Example scenario, global state has pinned filters and new map is created
      const defaultDataView = await (0, _kibana_services.getIndexPatternService)().getDefaultDataView();
      if (defaultDataView) {
        indexPatterns = [defaultDataView];
      }
    } else {
      indexPatterns = await (0, _index_pattern_util.getIndexPatternsFromIds)(nextIndexPatternIds);
    }
    if (!this._isMounted) {
      return;
    }

    // ignore results for outdated requests
    if (!_lodash.default.isEqual(nextIndexPatternIds, this._prevIndexPatternIds)) {
      return;
    }
    this.setState({
      indexPatterns
    });
  }
  _getInitialTime(mapState) {
    if (this._initialTimeFromUrl) {
      return this._initialTimeFromUrl;
    }
    return !this.props.savedMap.hasSaveAndReturnConfig() && mapState !== null && mapState !== void 0 && mapState.timeFilters ? mapState.timeFilters : (0, _kibana_services.getTimeFilter)().getTime();
  }
  _initMapAndLayerSettings(mapState) {
    const globalState = this._getGlobalState();
    const savedObjectFilters = mapState !== null && mapState !== void 0 && mapState.filters ? mapState.filters : [];
    const appFilters = this._appStateManager.getFilters() || [];
    const query = (0, _saved_map.getInitialQuery)({
      mapState,
      appState: this._appStateManager.getAppState()
    });
    if (query) {
      (0, _kibana_services.getData)().query.queryString.setQuery(query);
    }
    this._onQueryChange({
      filters: [..._lodash.default.get(globalState, 'filters', []), ...appFilters, ...savedObjectFilters],
      query,
      time: this._getInitialTime(mapState)
    });
    this._onRefreshConfigChange((0, _saved_map.getInitialRefreshConfig)({
      mapState,
      globalState
    }));
  }
  _onRefreshConfigChange({
    isPaused,
    interval
  }) {
    this.setState({
      isRefreshPaused: isPaused,
      refreshInterval: interval
    });
    this._updateGlobalState({
      refreshInterval: {
        pause: isPaused,
        value: interval
      }
    });
  }
  async _initMap() {
    var _this$props$history$l, _historyLocationState;
    // Handle redirect with adhoc data view spec provided via history location state (MAPS_APP_LOCATOR)
    const historyLocationState = (_this$props$history$l = this.props.history.location) === null || _this$props$history$l === void 0 ? void 0 : _this$props$history$l.state;
    if (historyLocationState !== null && historyLocationState !== void 0 && (_historyLocationState = historyLocationState.dataViewSpec) !== null && _historyLocationState !== void 0 && _historyLocationState.id) {
      const dataViewService = (0, _kibana_services.getIndexPatternService)();
      try {
        const dataView = await dataViewService.get(historyLocationState.dataViewSpec.id);
        if (!dataView.isPersisted()) {
          await dataViewService.create(historyLocationState.dataViewSpec);
        }
      } catch (error) {
        // ignore errors, not a critical error for viewing map - layer(s) using data view will surface error
      }
    }
    try {
      await this.props.savedMap.whenReady();
    } catch (err) {
      if (this._isMounted) {
        (0, _kibana_services.getToasts)().addWarning({
          title: _i18n.i18n.translate('xpack.maps.loadMap.errorAttemptingToLoadSavedMap', {
            defaultMessage: `Unable to load map`
          }),
          text: `${err.message}`
        });
        this.props.history.push('/');
      }
      return;
    }
    if (!this._isMounted) {
      return;
    }
    const sharingSavedObjectProps = this.props.savedMap.getSharingSavedObjectProps();
    const spaces = (0, _kibana_services.getSpacesApi)();
    if (spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'aliasMatch') {
      // We found this object by a legacy URL alias from its old ID; redirect the user to the page with its new ID, preserving any URL hash
      const newObjectId = sharingSavedObjectProps.aliasTargetId; // This is always defined if outcome === 'aliasMatch'
      const newPath = `${(0, _constants.getEditPath)(newObjectId)}${this.props.history.location.hash}`;
      await spaces.ui.redirectLegacyUrl({
        path: newPath,
        aliasPurpose: sharingSavedObjectProps.aliasPurpose,
        objectNoun: _constants.MAP_EMBEDDABLE_NAME
      });
      return;
    }
    this.props.savedMap.setBreadcrumbs(this.props.history);
    (0, _kibana_services.getCoreChrome)().docTitle.change(this.props.savedMap.getTitle());
    const savedObjectId = this.props.savedMap.getSavedObjectId();
    if (savedObjectId) {
      (0, _kibana_services.getCoreChrome)().recentlyAccessed.add((0, _constants.getFullPath)(savedObjectId), this.props.savedMap.getTitle(), savedObjectId);
    }
    let mapState;
    try {
      const attributes = this.props.savedMap.getAttributes();
      if (attributes.mapStateJSON) {
        mapState = JSON.parse(attributes.mapStateJSON);
      }
    } catch (e) {
      // ignore malformed mapStateJSON, not a critical error for viewing map - map will just use defaults
    }
    this._initMapAndLayerSettings(mapState);
    this.setState({
      initialized: true
    });
  }
  _renderTopNav() {
    if (this.props.isFullScreen) {
      return null;
    }
    const topNavConfig = (0, _top_nav_config.getTopNavConfig)({
      savedMap: this.props.savedMap,
      isOpenSettingsDisabled: this.props.isOpenSettingsDisabled,
      isSaveDisabled: this.props.isSaveDisabled,
      enableFullScreen: this.props.enableFullScreen,
      openMapSettings: this.props.openMapSettings,
      inspectorAdapters: this.props.inspectorAdapters,
      history: this.props.history
    });
    const {
      TopNavMenu
    } = (0, _kibana_services.getNavigation)().ui;
    return /*#__PURE__*/_react.default.createElement(TopNavMenu, {
      setMenuMountPoint: this.props.setHeaderActionMenu,
      appName: _constants.APP_ID,
      badges: this.props.savedMap.isManaged() ? [(0, _managedContentBadge.getManagedContentBadge)(_i18n.i18n.translate('xpack.maps.mapController.managedMapDescriptionTooltip', {
        defaultMessage: 'Elastic manages this map. Save any changes to a new map.'
      }))] : undefined,
      config: topNavConfig,
      indexPatterns: this.state.indexPatterns,
      filters: this.props.filters,
      query: this.props.query,
      onQuerySubmit: ({
        dateRange,
        query
      }) => {
        const isUpdate = !_lodash.default.isEqual(dateRange, this.props.timeFilters) || !_lodash.default.isEqual(query, this.props.query);
        if (isUpdate) {
          this._onQueryChange({
            query,
            time: dateRange
          });
        } else {
          this.props.setQuery({
            forceRefresh: true
          });
        }
      },
      onFiltersUpdated: this._onFiltersChange,
      dateRangeFrom: this.props.timeFilters.from,
      dateRangeTo: this.props.timeFilters.to,
      isRefreshPaused: this.state.isRefreshPaused,
      refreshInterval: this.state.refreshInterval,
      onRefreshChange: ({
        isPaused,
        refreshInterval
      }) => {
        this._onRefreshConfigChange({
          isPaused,
          interval: refreshInterval
        });
      },
      showSearchBar: true,
      showFilterBar: true,
      showDatePicker: true,
      allowSavingQueries: true,
      savedQuery: this.state.savedQuery,
      onSaved: this._updateStateFromSavedQuery,
      onSavedQueryUpdated: this._updateStateFromSavedQuery,
      onClearSavedQuery: () => {
        const {
          filterManager,
          queryString
        } = (0, _kibana_services.getData)().query;
        this.setState({
          savedQuery: undefined
        });
        this._appStateManager.setQueryAndFilters({
          savedQueryId: ''
        });
        this._onQueryChange({
          filters: filterManager.getGlobalFilters(),
          query: queryString.getDefaultQuery()
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 502,
        columnNumber: 7
      }
    });
  }
  _renderLegacyUrlConflict() {
    const sharingSavedObjectProps = this.props.savedMap.getSharingSavedObjectProps();
    const spaces = (0, _kibana_services.getSpacesApi)();
    return spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'conflict' ? spaces.ui.components.getLegacyUrlConflict({
      objectNoun: _constants.MAP_EMBEDDABLE_NAME,
      currentObjectId: this.props.savedMap.getSavedObjectId(),
      otherObjectId: sharingSavedObjectProps.aliasTargetId,
      otherObjectPath: `${(0, _constants.getEditPath)(sharingSavedObjectProps.aliasTargetId)}${this.props.history.location.hash}`
    }) : null;
  }
  render() {
    if (!this.state.initialized) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      id: "maps-plugin",
      css: [styles.wrapper, this.props.isFullScreen && styles.fullScreen],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 597,
        columnNumber: 7
      }
    }, this._renderTopNav(), /*#__PURE__*/_react.default.createElement("h1", {
      className: "euiScreenReaderOnly",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 599,
        columnNumber: 9
      }
    }, `screenTitle placeholder`), /*#__PURE__*/_react.default.createElement("div", {
      id: "react-maps-root",
      css: styles.reactMapsRoot,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 600,
        columnNumber: 9
      }
    }, this._renderLegacyUrlConflict(), /*#__PURE__*/_react.default.createElement(_map_container.MapContainer, {
      addFilters: this._addFilter,
      title: this.props.savedMap.getAttributes().title,
      description: this.props.savedMap.getAttributes().description,
      waitUntilTimeLayersLoad$: (0, _wait_until_time_layers_load.waitUntilTimeLayersLoad$)(this.props.savedMap.getStore()),
      isSharable: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 602,
        columnNumber: 11
      }
    })));
  }
}
exports.MapApp = MapApp;