"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UtmForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/toolbar_overlay/set_view_control/utm_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class UtmForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_onZoneChange", evt => {
      this.setState({
        zone: _lodash.default.isNull(evt.target.value) ? '' : evt.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onEastingChange", evt => {
      this.setState({
        easting: _lodash.default.isNull(evt.target.value) ? '' : evt.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onNorthingChange", evt => {
      this.setState({
        northing: _lodash.default.isNull(evt.target.value) ? '' : evt.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onZoomChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        zoom: isNaN(sanitizedValue) ? '' : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(this, "_onSubmit", () => {
      const point = this._toPoint();
      if (point) {
        this.props.onSubmit(point.lat, point.lon, this.state.zoom);
      }
    });
    const utm = (0, _utils.ddToUTM)(this.props.center.lat, this.props.center.lon);
    this.state = {
      northing: utm.northing,
      easting: utm.easting,
      zone: utm.zone,
      zoom: this.props.zoom
    };
  }
  _toPoint() {
    const {
      northing,
      easting,
      zone
    } = this.state;
    return northing === '' || easting === '' || zone.length < 2 ? undefined : (0, _utils.utmToDD)(northing, easting, zone.substring(0, zone.length - 1));
  }
  _isUtmInvalid() {
    const point = this._toPoint();
    return point === undefined;
  }
  render() {
    const isUtmInvalid = this._isUtmInvalid();
    const northingError = isUtmInvalid || this.state.northing === '' ? _i18n.i18n.translate('xpack.maps.setViewControl.utmInvalidNorthing', {
      defaultMessage: 'UTM Northing is invalid'
    }) : null;
    const eastingError = isUtmInvalid || this.state.northing === '' ? _i18n.i18n.translate('xpack.maps.setViewControl.utmInvalidEasting', {
      defaultMessage: 'UTM Easting is invalid'
    }) : null;
    const zoneError = isUtmInvalid || this.state.northing === '' ? _i18n.i18n.translate('xpack.maps.setViewControl.utmInvalidZone', {
      defaultMessage: 'UTM Zone is invalid'
    }) : null;
    const {
      isInvalid: isZoomInvalid,
      error: zoomError
    } = (0, _utils.withinRange)(this.state.zoom, this.props.settings.minZoom, this.props.settings.maxZoom);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.utmZoneLabel', {
        defaultMessage: 'UTM Zone'
      }),
      isInvalid: isUtmInvalid,
      error: zoneError,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      value: this.state.zone,
      onChange: this._onZoneChange,
      isInvalid: isUtmInvalid,
      "data-test-subj": "utmZoneInput",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.utmEastingLabel', {
        defaultMessage: 'UTM Easting'
      }),
      isInvalid: isUtmInvalid,
      error: eastingError,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.easting,
      onChange: this._onEastingChange,
      isInvalid: isUtmInvalid,
      "data-test-subj": "utmEastingInput",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.utmNorthingLabel', {
        defaultMessage: 'UTM Northing'
      }),
      isInvalid: isUtmInvalid,
      error: northingError,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.northing,
      onChange: this._onNorthingChange,
      isInvalid: isUtmInvalid,
      "data-test-subj": "utmNorthingInput",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.zoomLabel', {
        defaultMessage: 'Zoom'
      }),
      isInvalid: isZoomInvalid,
      error: zoomError,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.zoom,
      onChange: this._onZoomChange,
      isInvalid: isZoomInvalid,
      "data-test-subj": "zoomInput",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      disabled: isUtmInvalid || isZoomInvalid,
      onClick: this._onSubmit,
      "data-test-subj": "submitViewButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.setViewControl.submitButtonLabel",
      defaultMessage: "Go",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 13
      }
    }))));
  }
}
exports.UtmForm = UtmForm;