"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrependButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _symbol_icon = require("../legend/symbol_icon");
var _kibana_services = require("../../../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/symbol/prepend_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const prependButtonStyles = {
  icon: ({
    euiTheme
  }) => ({
    margin: `0 ${euiTheme.size.xs}`
  })
};
const PrependButton = ({
  value,
  svg
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(prependButtonStyles);
  return /*#__PURE__*/_react.default.createElement(_symbol_icon.SymbolIcon, {
    key: value,
    css: styles.icon,
    symbolId: value,
    svg: svg,
    fill: (0, _kibana_services.getIsDarkMode)() ? 'rgb(223, 229, 239)' : 'rgb(52, 55, 65)',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
};
exports.PrependButton = PrependButton;