"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLEditor = ESQLEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _public = require("@kbn/esql/public");
var _esql_utils = require("./esql_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/esql_source/esql_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ESQLEditor(props) {
  const isMounted = (0, _useMountedState.default)();
  const [error, setError] = (0, _react.useState)();
  const [warning, setWarning] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [localQuery, setLocalQuery] = (0, _react.useState)({
    esql: props.esql
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.ESQLLangEditor, {
    query: localQuery,
    onTextLangQueryChange: setLocalQuery,
    onTextLangQuerySubmit: async query => {
      if (!query) {
        return;
      }
      if (warning) {
        setWarning(undefined);
      }
      if (error) {
        setError(undefined);
      }
      setIsLoading(true);
      try {
        const esql = query.esql;
        const esqlMeta = await (0, _esql_utils.getESQLMeta)(esql);
        if (!isMounted()) {
          return;
        }
        (0, _esql_utils.verifyGeometryColumn)(esqlMeta.columns);
        if (esqlMeta.columns.length >= 6) {
          setWarning(_i18n.i18n.translate('xpack.maps.esqlSource.tooManyColumnsWarning', {
            defaultMessage: `ES|QL statement returns {count} columns. For faster maps, use 'DROP' or 'KEEP' to narrow columns.`,
            values: {
              count: esqlMeta.columns.length
            }
          }));
        }
        props.onESQLChange({
          esql,
          ...esqlMeta
        });
      } catch (err) {
        if (!isMounted()) {
          return;
        }
        setError(err);
      }
      setIsLoading(false);
    },
    errors: error ? [error] : undefined,
    warning: warning,
    editorIsInline: true,
    hideRunQueryText: true,
    isLoading: isLoading,
    disableSubmitAction: (0, _lodash.isEqual)(localQuery, props.esql),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
}