"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.highlightFieldValue = exports.HighlightMarker = exports.ActiveHighlightMarker = void 0;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/logs_shared/public/components/logging/log_text_stream/highlighting.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ActiveHighlightMarker = exports.ActiveHighlightMarker = _styled.default.mark`
  color: ${({
  theme
}) => theme.euiTheme.colors.textParagraph};
  background-color: ${({
  theme
}) => theme.euiTheme.colors.backgroundFilledAccent};
  outline: ${({
  theme
}) => `${theme.euiTheme.border.width.thin} solid ${theme.euiTheme.colors.backgroundFilledAccent}`};
`;
const HighlightMarker = exports.HighlightMarker = _styled.default.mark`
  color: ${({
  theme
}) => theme.euiTheme.colors.textParagraph};
  background-color: ${({
  theme
}) => theme.euiTheme.colors.backgroundLightAccent};
  outline: ${({
  theme
}) => `${theme.euiTheme.border.width.thin} solid ${theme.euiTheme.colors.backgroundLightAccent}`};
`;
const highlightFieldValue = (value, highlightTerms, HighlightComponent) => highlightTerms.reduce((fragments, highlightTerm, index) => {
  const lastFragment = fragments[fragments.length - 1];
  if (typeof lastFragment !== 'string') {
    return fragments;
  }
  const highlightTermPosition = lastFragment.indexOf(highlightTerm);
  if (highlightTermPosition > -1) {
    return [...fragments.slice(0, fragments.length - 1), lastFragment.slice(0, highlightTermPosition), /*#__PURE__*/_react.default.createElement(HighlightComponent, {
      key: `highlight-${highlightTerm}-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }, highlightTerm), lastFragment.slice(highlightTermPosition + highlightTerm.length)];
  } else {
    return fragments;
  }
}, [value]);
exports.highlightFieldValue = highlightFieldValue;