"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinksEmbeddableFactory = exports.LinksContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react2 = require("@emotion/react");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationUtil = require("@kbn/presentation-util");
var _content_management = require("../../common/content_management");
var _dashboard_link_component = require("../components/dashboard_link/dashboard_link_component");
var _external_link_component = require("../components/external_link/external_link_component");
var _common = require("../../common");
var _content_management2 = require("../content_management");
var _resolve_links = require("../lib/resolve_links");
var _add_links_panel_action = require("../actions/add_links_panel_action");
var _kibana_services = require("../services/kibana_services");
var _load_from_library = require("../content_management/load_from_library");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/embeddable/links_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LinksContext = exports.LinksContext = /*#__PURE__*/(0, _react.createContext)(null);
const getLinksEmbeddableFactory = () => {
  const linksEmbeddableFactory = {
    type: _common.LINKS_EMBEDDABLE_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      var _intialLinksState$lin;
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const savedObjectId = initialState.rawState.savedObjectId;
      const intialLinksState = savedObjectId ? await (0, _load_from_library.loadFromLibrary)(savedObjectId) : initialState.rawState;
      const isByReference = savedObjectId !== undefined;
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      if (!(0, _add_links_panel_action.isParentApiCompatible)(parentApi)) blockingError$.next(new _public.PanelIncompatibleError());
      const defaultDescription$ = new _rxjs.BehaviorSubject(isByReference ? intialLinksState.description : undefined);
      const defaultTitle$ = new _rxjs.BehaviorSubject(isByReference ? intialLinksState.title : undefined);
      const layout$ = new _rxjs.BehaviorSubject(intialLinksState.layout);
      const resolvedLinks$ = new _rxjs.BehaviorSubject(await (0, _resolve_links.resolveLinks)((_intialLinksState$lin = intialLinksState.links) !== null && _intialLinksState$lin !== void 0 ? _intialLinksState$lin : []));
      function serializeByReference(libraryId) {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            savedObjectId: libraryId
          }
        };
      }
      function serializeByValue() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            layout: layout$.getValue(),
            links: (0, _resolve_links.serializeResolvedLinks)(resolvedLinks$.getValue())
          }
        };
      }
      const serializeState = () => isByReference ? serializeByReference(savedObjectId) : serializeByValue();
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, layout$.pipe((0, _rxjs.map)(() => undefined)), resolvedLinks$.pipe((0, _rxjs.map)(() => undefined))),
        getComparators: () => {
          return {
            ..._presentationPublishing.titleComparators,
            layout: isByReference ? 'skip' : 'referenceEquality',
            links: isByReference ? 'skip' : (aLinks, bLinks) => {
              if ((aLinks === null || aLinks === void 0 ? void 0 : aLinks.length) !== (bLinks === null || bLinks === void 0 ? void 0 : bLinks.length)) {
                return false;
              }
              const hasLinkDifference = (aLinks !== null && aLinks !== void 0 ? aLinks : []).some((linkFromA, index) => {
                const linkFromB = bLinks === null || bLinks === void 0 ? void 0 : bLinks[index];
                return !(0, _fastDeepEqual.default)((0, _lodash.omitBy)(linkFromA, _lodash.isUndefined), (0, _lodash.omitBy)(linkFromB, _lodash.isUndefined));
              });
              return !hasLinkDifference;
            },
            savedObjectId: 'skip'
          };
        },
        onReset: async lastSaved => {
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          if (!savedObjectId) {
            var _lastSaved$rawState, _links, _lastSaved$rawState2;
            layout$.next(lastSaved === null || lastSaved === void 0 ? void 0 : (_lastSaved$rawState = lastSaved.rawState) === null || _lastSaved$rawState === void 0 ? void 0 : _lastSaved$rawState.layout);
            resolvedLinks$.next(await (0, _resolve_links.resolveLinks)((_links = lastSaved === null || lastSaved === void 0 ? void 0 : (_lastSaved$rawState2 = lastSaved.rawState) === null || _lastSaved$rawState2 === void 0 ? void 0 : _lastSaved$rawState2.links) !== null && _links !== void 0 ? _links : []));
          }
        }
      });
      const api = finalizeApi({
        ...titleManager.api,
        ...unsavedChangesApi,
        blockingError$,
        defaultTitle$,
        defaultDescription$,
        isEditingEnabled: () => Boolean(blockingError$.value === undefined),
        getTypeDisplayName: () => _common.DISPLAY_NAME,
        serializeState,
        saveToLibrary: async newTitle => {
          defaultTitle$.next(newTitle);
          const {
            item: {
              id
            }
          } = await _content_management2.linksClient.create({
            data: {
              layout: layout$.getValue(),
              links: (0, _resolve_links.serializeResolvedLinks)(resolvedLinks$.getValue()),
              title: newTitle
            }
          });
          return id;
        },
        getSerializedStateByValue: serializeByValue,
        getSerializedStateByReference: serializeByReference,
        canLinkToLibrary: async () => !isByReference,
        canUnlinkFromLibrary: async () => isByReference,
        checkForDuplicateTitle: async (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => {
          await (0, _content_management2.checkForDuplicateTitle)({
            title: newTitle,
            copyOnSave: false,
            lastSavedTitle: '',
            isTitleDuplicateConfirmed,
            onTitleDuplicate
          });
        },
        onEdit: async () => {
          (0, _presentationUtil.openLazyFlyout)({
            core: _kibana_services.coreServices,
            parentApi,
            loadContent: async ({
              closeFlyout
            }) => {
              var _titleManager$api$des, _titleManager$api$tit;
              const {
                getEditorFlyout
              } = await Promise.resolve().then(() => _interopRequireWildcard(require('../editor/get_editor_flyout')));
              return getEditorFlyout({
                initialState: {
                  description: (_titleManager$api$des = titleManager.api.description$.getValue()) !== null && _titleManager$api$des !== void 0 ? _titleManager$api$des : defaultDescription$.getValue(),
                  layout: layout$.getValue(),
                  links: resolvedLinks$.getValue(),
                  title: (_titleManager$api$tit = titleManager.api.title$.getValue()) !== null && _titleManager$api$tit !== void 0 ? _titleManager$api$tit : defaultTitle$.getValue(),
                  savedObjectId
                },
                parentDashboard: parentApi,
                onCompleteEdit: async newState => {
                  var _newState$links;
                  if (!newState) return;

                  // if the by reference state has changed during this edit, reinitialize the panel.
                  const nextSavedObjectId = newState === null || newState === void 0 ? void 0 : newState.savedObjectId;
                  const nextIsByReference = nextSavedObjectId !== undefined;
                  if (nextIsByReference !== isByReference && (0, _presentationContainers.apiIsPresentationContainer)(api.parentApi)) {
                    const serializedState = nextIsByReference ? serializeByReference(nextSavedObjectId) : serializeByValue();
                    serializedState.rawState.title = newState.title;
                    api.parentApi.replacePanel(api.uuid, {
                      serializedState,
                      panelType: api.type
                    });
                    return;
                  }
                  defaultDescription$.next(newState.description);
                  defaultTitle$.next(newState.title);
                  layout$.next(newState.layout);
                  resolvedLinks$.next((_newState$links = newState.links) !== null && _newState$links !== void 0 ? _newState$links : []);
                },
                closeFlyout
              });
            },
            flyoutProps: {
              'data-test-subj': 'links--panelEditor--flyout'
            }
          });
        }
      });
      const Component = () => {
        const [resolvedLinks, layout] = (0, _presentationPublishing.useBatchedPublishingSubjects)(resolvedLinks$, layout$);
        const linkItems = (0, _react.useMemo)(() => {
          if (!resolvedLinks) return {};
          return resolvedLinks.reduce((prev, currentLink) => {
            return {
              ...prev,
              [currentLink.id]: {
                id: currentLink.id,
                content: currentLink.type === _content_management.DASHBOARD_LINK_TYPE ? /*#__PURE__*/_react.default.createElement(_dashboard_link_component.DashboardLinkComponent, {
                  key: currentLink.id,
                  link: currentLink,
                  layout: layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT,
                  parentApi: parentApi,
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 243,
                    columnNumber: 21
                  }
                }) : /*#__PURE__*/_react.default.createElement(_external_link_component.ExternalLinkComponent, {
                  key: currentLink.id,
                  link: currentLink,
                  layout: layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT,
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 250,
                    columnNumber: 21
                  }
                })
              }
            };
          }, {});
        }, [resolvedLinks, layout]);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          className: layout === _content_management.LINKS_HORIZONTAL_LAYOUT ? 'eui-xScroll' : 'eui-yScroll',
          paddingSize: "xs",
          "data-shared-item": true,
          "data-rendering-count": 1,
          "data-test-subj": "links--component",
          borderRadius: "none",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 261,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
          maxWidth: false,
          css: styles,
          className: `${layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT}LayoutWrapper`,
          "data-test-subj": "links--component--listGroup",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 269,
            columnNumber: 13
          }
        }, resolvedLinks === null || resolvedLinks === void 0 ? void 0 : resolvedLinks.map(link => linkItems[link.id].content)));
      };
      return {
        api,
        Component
      };
    }
  };
  return linksEmbeddableFactory;
};
exports.getLinksEmbeddableFactory = getLinksEmbeddableFactory;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  '.linksPanelLink': {
    maxWidth: 'fit-content' // ensures that the error tooltip shows up **right beside** the link label
  },
  '&.verticalLayoutWrapper': {
    gap: euiTheme.size.xs
  },
  '&.horizontalLayoutWrapper': {
    height: '100%',
    display: 'flex',
    flexWrap: 'nowrap',
    alignItems: 'center',
    flexDirection: 'row'
  }
});