"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.annotationLayerHasUnsavedChanges = exports.NON_BAR_SERIES = exports.BAR_SERIES = exports.AREA_SERIES = void 0;
exports.flipSeriesType = flipSeriesType;
exports.getAnnotationLayerErrors = getAnnotationLayerErrors;
exports.getColumnToLabelMap = exports.getBarSeriesLayers = void 0;
exports.getIconForSeries = getIconForSeries;
exports.hasBarSeries = exports.hasAreaSeries = exports.getUniqueSeriesTypes = exports.getSeriesColor = void 0;
exports.hasHistogramSeries = hasHistogramSeries;
exports.isAreaLayer = exports.hasNonBarSeries = void 0;
exports.isBarLayer = isBarLayer;
exports.isHorizontalChart = isHorizontalChart;
exports.isHorizontalSeries = isHorizontalSeries;
exports.isPercentageSeries = isPercentageSeries;
exports.isStackedChart = isStackedChart;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eventAnnotationComponents = require("@kbn/event-annotation-components");
var _i18n = require("@kbn/i18n");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _types = require("./types");
var _visualization_helpers = require("./visualization_helpers");
var _user_messages_ids = require("../../user_messages_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/state_helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isHorizontalSeries(seriesType) {
  return seriesType === 'bar_horizontal' || seriesType === 'bar_horizontal_stacked' || seriesType === 'bar_horizontal_percentage_stacked';
}
function flipSeriesType(seriesType) {
  switch (seriesType) {
    case 'bar':
      return 'bar_horizontal';
    case 'bar_stacked':
      return 'bar_horizontal_stacked';
    case 'bar_percentage_stacked':
      return 'bar_horizontal_percentage_stacked';
    case 'bar_horizontal':
      return 'bar';
    case 'bar_horizontal_stacked':
      return 'bar_stacked';
    case 'bar_horizontal_percentage_stacked':
      return 'bar_percentage_stacked';
    default:
      return 'bar_horizontal';
  }
}
function isPercentageSeries(seriesType) {
  return seriesType === 'bar_percentage_stacked' || seriesType === 'bar_horizontal_percentage_stacked' || seriesType === 'area_percentage_stacked';
}
const AREA_SERIES = exports.AREA_SERIES = ['area_stacked', 'area', 'area_percentage_stacked'];
const NON_BAR_SERIES = exports.NON_BAR_SERIES = [...AREA_SERIES, 'line'];
const BAR_SERIES = exports.BAR_SERIES = ['bar', 'bar_stacked', 'bar_percentage_stacked', 'bar_horizontal', 'bar_horizontal_stacked', 'bar_horizontal_percentage_stacked'];
const hasNonBarSeries = layers => layers.some(layer => (0, _visualization_helpers.isDataLayer)(layer) && NON_BAR_SERIES.includes(layer.seriesType));
exports.hasNonBarSeries = hasNonBarSeries;
const hasBarSeries = layers => {
  return layers.some(layer => (0, _visualization_helpers.isDataLayer)(layer) && BAR_SERIES.includes(layer.seriesType));
};
exports.hasBarSeries = hasBarSeries;
const hasAreaSeries = layers => layers.some(layer => (0, _visualization_helpers.isDataLayer)(layer) && AREA_SERIES.includes(layer.seriesType));
exports.hasAreaSeries = hasAreaSeries;
const getBarSeriesLayers = layers => (0, _visualization_helpers.getDataLayers)(layers).filter(layer => BAR_SERIES.includes(layer.seriesType));
exports.getBarSeriesLayers = getBarSeriesLayers;
function isStackedChart(seriesType) {
  return seriesType.includes('stacked');
}
const isAreaLayer = layer => {
  return (0, _visualization_helpers.isDataLayer)(layer) && AREA_SERIES.includes(layer.seriesType);
};
exports.isAreaLayer = isAreaLayer;
function isBarLayer(layer) {
  return (0, _visualization_helpers.isDataLayer)(layer) && BAR_SERIES.includes(layer.seriesType);
}
const getUniqueSeriesTypes = layers => {
  return [...new Set((0, _visualization_helpers.getDataLayers)(layers).map(({
    seriesType
  }) => seriesType))];
};
exports.getUniqueSeriesTypes = getUniqueSeriesTypes;
function isHorizontalChart(layers) {
  return (0, _visualization_helpers.getDataLayers)(layers).every(l => isHorizontalSeries(l.seriesType));
}
function getIconForSeries(type) {
  const definition = _types.visualizationSubtypes.find(t => t.id === type);
  if (!definition) {
    throw new Error(`Unknown series type ${type}`);
  }
  return definition.icon || 'empty';
}
const getSeriesColor = (layer, accessor) => {
  var _layer$yConfig, _layer$yConfig$find;
  if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    var _layer$annotations, _layer$annotations$fi;
    return (layer === null || layer === void 0 ? void 0 : (_layer$annotations = layer.annotations) === null || _layer$annotations === void 0 ? void 0 : (_layer$annotations$fi = _layer$annotations.find(ann => ann.id === accessor)) === null || _layer$annotations$fi === void 0 ? void 0 : _layer$annotations$fi.color) || null;
  }
  if ((0, _visualization_helpers.isDataLayer)(layer) && layer.splitAccessor && !layer.collapseFn) {
    return null;
  }
  return (layer === null || layer === void 0 ? void 0 : (_layer$yConfig = layer.yConfig) === null || _layer$yConfig === void 0 ? void 0 : (_layer$yConfig$find = _layer$yConfig.find(yConfig => yConfig.forAccessor === accessor)) === null || _layer$yConfig$find === void 0 ? void 0 : _layer$yConfig$find.color) || null;
};
exports.getSeriesColor = getSeriesColor;
const getColumnToLabelMap = (layer, datasource) => {
  const columnToLabel = {};
  layer.accessors.concat((0, _visualization_helpers.isDataLayer)(layer) && layer.splitAccessor ? [layer.splitAccessor] : []).forEach(accessor => {
    const operation = datasource === null || datasource === void 0 ? void 0 : datasource.getOperationForColumnId(accessor);
    if (operation !== null && operation !== void 0 && operation.label) {
      columnToLabel[accessor] = operation.label;
    }
  });
  return columnToLabel;
};
exports.getColumnToLabelMap = getColumnToLabelMap;
function hasHistogramSeries(layers = [], datasourceLayers) {
  if (!datasourceLayers) {
    return false;
  }
  const validLayers = layers.filter(({
    accessors
  }) => accessors.length);
  return validLayers.some(({
    layerId,
    xAccessor
  }) => {
    var _datasourceLayers$lay;
    if (!xAccessor) {
      return false;
    }
    const xAxisOperation = (_datasourceLayers$lay = datasourceLayers[layerId]) === null || _datasourceLayers$lay === void 0 ? void 0 : _datasourceLayers$lay.getOperationForColumnId(xAccessor);
    return xAxisOperation && xAxisOperation.isBucketed && xAxisOperation.scale && xAxisOperation.scale !== 'ordinal';
  });
}
const annotationLayerHasUnsavedChanges = layer => {
  if (!(0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer)) {
    return false;
  }
  const currentConfig = {
    annotations: layer.annotations,
    ignoreGlobalFilters: layer.ignoreGlobalFilters,
    indexPatternId: layer.indexPatternId
  };
  const savedConfig = {
    annotations: layer.__lastSaved.annotations,
    ignoreGlobalFilters: layer.__lastSaved.ignoreGlobalFilters,
    indexPatternId: layer.__lastSaved.indexPatternId
  };
  return !(0, _fastDeepEqual.default)(currentConfig, savedConfig);
};
exports.annotationLayerHasUnsavedChanges = annotationLayerHasUnsavedChanges;
function createAnnotationErrorMessage(uniqueId, errorMessage, annotationId, annotationName) {
  return {
    uniqueId,
    severity: 'error',
    fixableInEditor: true,
    displayLocations: [{
      id: 'visualization'
    }, {
      id: 'dimensionButton',
      dimensionId: annotationId
    }],
    shortMessage: errorMessage,
    longMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.xyChart.annotationError",
      defaultMessage: "Annotation {annotationName} has an error: {errorMessage}",
      values: {
        annotationName,
        errorMessage
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 7
      }
    })
  };
}
function getAnnotationLayerErrors(layer, columnId, dataViews) {
  var _annotation$extraFiel;
  if (!layer) {
    return [];
  }
  const annotation = layer.annotations.find(({
    id
  }) => id === columnId);
  if (!annotation || !(0, _eventAnnotationComponents.isQueryAnnotationConfig)(annotation)) {
    return [];
  }
  const layerDataView = dataViews.indexPatterns[layer.indexPatternId];
  const invalidMessages = [];
  if (annotation.timeField == null || annotation.timeField === '') {
    invalidMessages.push(createAnnotationErrorMessage(_user_messages_ids.ANNOTATION_MISSING_TIME_FIELD, _i18n.i18n.translate('xpack.lens.xyChart.annotationError.timeFieldEmpty', {
      defaultMessage: 'Time field is missing'
    }), annotation.id, annotation.label));
  }
  if (annotation.timeField && !Boolean(layerDataView.getFieldByName(annotation.timeField))) {
    invalidMessages.push(createAnnotationErrorMessage(_user_messages_ids.ANNOTATION_TIME_FIELD_NOT_FOUND, _i18n.i18n.translate('xpack.lens.xyChart.annotationError.timeFieldNotFound', {
      defaultMessage: 'Time field {timeField} not found in data view {dataView}',
      values: {
        timeField: annotation.timeField,
        dataView: layerDataView.title
      }
    }), annotation.id, annotation.label));
  }
  const {
    isValid,
    error
  } = (0, _visualizationUiComponents.validateQuery)(annotation === null || annotation === void 0 ? void 0 : annotation.filter, layerDataView);
  if (!isValid && error) {
    invalidMessages.push(createAnnotationErrorMessage(_user_messages_ids.ANNOTATION_INVALID_FILTER_QUERY, error, annotation.id, annotation.label));
  }
  if (annotation.textField && !Boolean(layerDataView.getFieldByName(annotation.textField))) {
    invalidMessages.push(createAnnotationErrorMessage(_user_messages_ids.ANNOTATION_TEXT_FIELD_NOT_FOUND, _i18n.i18n.translate('xpack.lens.xyChart.annotationError.textFieldNotFound', {
      defaultMessage: 'Text field {textField} not found in data view {dataView}',
      values: {
        textField: annotation.textField,
        dataView: layerDataView.title
      }
    }), annotation.id, annotation.label));
  }
  if ((_annotation$extraFiel = annotation.extraFields) !== null && _annotation$extraFiel !== void 0 && _annotation$extraFiel.length) {
    const missingTooltipFields = [];
    for (const field of annotation.extraFields) {
      if (!Boolean(layerDataView.getFieldByName(field))) {
        missingTooltipFields.push(field);
      }
    }
    if (missingTooltipFields.length) {
      invalidMessages.push(createAnnotationErrorMessage(_user_messages_ids.ANNOTATION_MISSING_TOOLTIP_FIELD, _i18n.i18n.translate('xpack.lens.xyChart.annotationError.tooltipFieldNotFound', {
        defaultMessage: 'Tooltip {missingFields, plural, one {field} other {fields}} {missingTooltipFields} not found in data view {dataView}',
        values: {
          missingTooltipFields: missingTooltipFields.join(', '),
          missingFields: missingTooltipFields.length,
          dataView: layerDataView.title
        }
      }), annotation.id, annotation.label));
    }
  }
  return invalidMessages;
}