"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SizeOptions = exports.DEFAULT_TITLE_SIZE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/legacy_metric/metric_config_panel/size_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_TITLE_SIZE = exports.DEFAULT_TITLE_SIZE = 'm';
const titleSizes = [{
  id: 'xs',
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.metricSize.extraSmall', {
    defaultMessage: 'XS'
  })
}, {
  id: 's',
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.metricSize.small', {
    defaultMessage: 'S'
  })
}, {
  id: 'm',
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.metricSize.medium', {
    defaultMessage: 'M'
  })
}, {
  id: 'l',
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.metricSize.large', {
    defaultMessage: 'L'
  })
}, {
  id: 'xl',
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.metricSize.extraLarge', {
    defaultMessage: 'XL'
  })
}, {
  id: 'xxl',
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.metricSize.xxl', {
    defaultMessage: 'XXL'
  })
}];
const SizeOptions = ({
  state,
  setState
}) => {
  var _state$size;
  const currSizeIndex = titleSizes.findIndex(size => size.id === (state.size || DEFAULT_TITLE_SIZE));
  const changeSize = change => {
    setState({
      ...state,
      size: titleSizes[currSizeIndex + change].id
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "plus",
      onClick: () => changeSize(1),
      isDisabled: currSizeIndex === titleSizes.length - 1,
      "aria-label": _i18n.i18n.translate('xpack.lens.legacyMetric.sizeOptions.increaseSizeAriaLabel', {
        defaultMessage: 'Increase title size'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }),
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "minus",
      onClick: () => changeSize(-1),
      isDisabled: currSizeIndex === 0,
      "aria-label": _i18n.i18n.translate('xpack.lens.legacyMetric.sizeOptions.decreaseSizeAriaLabel', {
        defaultMessage: 'Decrease title size'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }),
    "data-test-subj": "lnsLegacyMetricSizeSelect",
    compressed: true,
    options: titleSizes.map(position => {
      return {
        value: position.id,
        dropdownDisplay: position.label,
        inputDisplay: position.label
      };
    }),
    valueOfSelected: (_state$size = state.size) !== null && _state$size !== void 0 ? _state$size : DEFAULT_TITLE_SIZE,
    onChange: value => {
      setState({
        ...state,
        size: value
      });
    },
    itemLayoutAlign: "top",
    hasDividers: true,
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.lens.legacyMetric.sizeOptions.titleSizeAriaLabel', {
      defaultMessage: 'Title size'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  });
};
exports.SizeOptions = SizeOptions;