"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorMappingByValues = ColorMappingByValues;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _i18n = require("@kbn/i18n");
var _palette_panel_container = require("./palette_panel_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/coloring/color_mapping_by_values.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ColorMappingByValues({
  palette,
  isInlineEditing,
  setPalette,
  paletteService,
  panelRef,
  dataBounds
}) {
  var _palette$params$stops, _palette$params, _palette$params$stops2;
  const colors = (_palette$params$stops = (_palette$params = palette.params) === null || _palette$params === void 0 ? void 0 : (_palette$params$stops2 = _palette$params.stops) === null || _palette$params$stops2 === void 0 ? void 0 : _palette$params$stops2.map(({
    color
  }) => color)) !== null && _palette$params$stops !== void 0 ? _palette$params$stops : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingSectionLabel', {
      defaultMessage: 'Color mapping'
    }),
    style: {
      alignItems: 'center'
    },
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_palette_panel_container.PalettePanelContainer, {
    palette: colors,
    siblingRef: panelRef,
    title: _i18n.i18n.translate('xpack.lens.colorMapping.editColorsTitle', {
      defaultMessage: 'Edit colors'
    }),
    isInlineEditing: isInlineEditing,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "lns-palettePanel-values",
    className: "lnsPalettePanel__section lnsPalettePanel__section--shaded lnsIndexPatternDimensionEditor--padded",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_coloring.CustomizablePalette, {
    palettes: paletteService,
    dataBounds: dataBounds,
    activePalette: palette,
    setPalette: p => {
      setPalette(p);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))));
}