"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorFrame = EditorFrame;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _utils = require("../../utils");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _data_panel_wrapper = require("./data_panel_wrapper");
var _banner_wrapper = require("./banner_wrapper");
var _config_panel = require("./config_panel");
var _frame_layout = require("./frame_layout");
var _suggestion_panel = require("./suggestion_panel");
var _workspace_panel = require("./workspace_panel");
var _suggestion_helpers = require("./suggestion_helpers");
var _state_management = require("../../state_management");
var _lens_ui_errors = require("../../lens_ui_errors");
var _user_messages_utils = require("../../user_messages_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/editor_frame.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EditorFrame(props) {
  const {
    datasourceMap,
    visualizationMap
  } = props;
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const areDatasourcesLoaded = (0, _state_management.useLensSelector)(_state_management.selectAreDatasourcesLoaded);
  const isVisualizationLoaded = !!visualization.state;
  const visualizationTypeIsKnown = Boolean(visualization.activeId && props.visualizationMap[visualization.activeId]);
  const framePublicAPI = (0, _state_management.useLensSelector)(state => (0, _state_management.selectFramePublicAPI)(state, datasourceMap));
  framePublicAPI.absDateRange = (0, _utils.getAbsoluteDateRange)(props.plugins.data.query.timefilter.timefilter);

  // Using a ref to prevent rerenders in the child components while keeping the latest state
  const getSuggestionForField = (0, _react.useRef)();
  getSuggestionForField.current = field => {
    if (!field || !activeDatasourceId) {
      return;
    }
    return (0, _suggestion_helpers.getTopSuggestionForField)(framePublicAPI.datasourceLayers, visualization, datasourceStates, visualizationMap, datasourceMap[activeDatasourceId], field, framePublicAPI.dataViews, true);
  };
  const hasSuggestionForField = (0, _react.useCallback)(field => getSuggestionForField.current(field) !== undefined, [getSuggestionForField]);
  const dropOntoWorkspace = (0, _react.useCallback)(field => {
    const suggestion = getSuggestionForField.current(field);
    if (suggestion) {
      (0, _lens_ui_telemetry.trackUiCounterEvents)('drop_onto_workspace');
      (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, suggestion, {
        clearStagedPreview: true
      });
    }
  }, [getSuggestionForField, dispatchLens]);
  const onError = (0, _react.useCallback)(error => {
    (0, _lens_ui_errors.showMemoizedErrorNotification)(error);
  }, []);
  const bannerMessages = props.getUserMessages('banner', {
    severity: 'warning'
  });
  const telemetryMiddleware = (0, _react.useCallback)(action => {
    if (action.type === 'dropToTarget') {
      (0, _lens_ui_telemetry.trackUiCounterEvents)('drop_total');
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, {
    initialState: {
      dataTestSubjPrefix: 'lnsDragDrop'
    },
    customMiddleware: telemetryMiddleware,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_frame_layout.FrameLayout, {
    bannerMessages: bannerMessages.length ? /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_banner_wrapper.BannerWrapper, {
      nodes: bannerMessages.map(_user_messages_utils.getLongMessage),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 15
      }
    })) : undefined,
    dataPanel: /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_data_panel_wrapper.DataPanelWrapper, {
      core: props.core,
      plugins: props.plugins,
      datasourceMap: datasourceMap,
      visualizationMap: visualizationMap,
      showNoDataPopover: props.showNoDataPopover,
      dropOntoWorkspace: dropOntoWorkspace,
      hasSuggestionForField: hasSuggestionForField,
      indexPatternService: props.indexPatternService,
      frame: framePublicAPI,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    })),
    configPanel: areDatasourcesLoaded && /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_config_panel.ConfigPanelWrapper, {
      core: props.core,
      datasourceMap: datasourceMap,
      visualizationMap: visualizationMap,
      framePublicAPI: framePublicAPI,
      uiActions: props.plugins.uiActions,
      dataViews: props.plugins.dataViews,
      data: props.plugins.data,
      indexPatternService: props.indexPatternService,
      getUserMessages: props.getUserMessages,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 15
      }
    })),
    workspacePanel: areDatasourcesLoaded && isVisualizationLoaded && /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_workspace_panel.WorkspacePanel, {
      core: props.core,
      plugins: props.plugins,
      ExpressionRenderer: props.ExpressionRenderer,
      lensInspector: props.lensInspector,
      datasourceMap: datasourceMap,
      visualizationMap: visualizationMap,
      framePublicAPI: framePublicAPI,
      getSuggestionForField: getSuggestionForField.current,
      getUserMessages: props.getUserMessages,
      addUserMessages: props.addUserMessages,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 15
      }
    })),
    suggestionsPanel: visualizationTypeIsKnown && areDatasourcesLoaded && /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_suggestion_panel.SuggestionPanelWrapper, {
      ExpressionRenderer: props.ExpressionRenderer,
      datasourceMap: datasourceMap,
      visualizationMap: visualizationMap,
      frame: framePublicAPI,
      getUserMessages: props.getUserMessages,
      nowProvider: props.plugins.data.nowProvider,
      core: props.core,
      showOnlyIcons: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 15
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }));
}