"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerHeader = LayerHeader;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_components = require("../../../shared_components");
var _chart_switch_popover = require("./chart_switch/chart_switch_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/layer_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LayerHeader({
  activeVisualizationId,
  layerConfigProps,
  visualizationMap,
  datasourceMap,
  onlyAllowSwitchToSubtypes
}) {
  var _activeVisualization$, _activeVisualization$2;
  const activeVisualization = visualizationMap[activeVisualizationId];
  if (!activeVisualization) {
    return null;
  }
  const customLayerHeader = (_activeVisualization$ = activeVisualization.getCustomLayerHeader) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.call(activeVisualization, layerConfigProps);
  if (customLayerHeader) {
    return customLayerHeader;
  }
  const availableVisualizationMap = filterVisualizationMap(visualizationMap, activeVisualization.id, layerConfigProps.frame, onlyAllowSwitchToSubtypes);
  const hasOnlyOneVisAvailable = Object.keys(availableVisualizationMap).length === 1 && Object.values(availableVisualizationMap)[0].visualizationTypes.length === 1;
  if (hasOnlyOneVisAvailable) {
    const description = activeVisualization.getDescription(layerConfigProps.state);
    return /*#__PURE__*/_react.default.createElement(_shared_components.StaticHeader, {
      label: description.label,
      icon: description.icon,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 12
      }
    });
  }
  const SubtypeSwitch = (_activeVisualization$2 = activeVisualization.getSubtypeSwitch) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, layerConfigProps);
  return SubtypeSwitch ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_switch_popover.ChartSwitchPopover, {
    datasourceMap: datasourceMap,
    visualizationMap: availableVisualizationMap,
    framePublicAPI: layerConfigProps.frame,
    layerId: layerConfigProps.layerId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SubtypeSwitch, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }))) : /*#__PURE__*/_react.default.createElement(_chart_switch_popover.ChartSwitchPopover, {
    datasourceMap: datasourceMap,
    visualizationMap: availableVisualizationMap,
    framePublicAPI: layerConfigProps.frame,
    layerId: layerConfigProps.layerId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  });
}
const filterVisualizationMap = (visualizationMap, activeVisualizationId, frame, onlyAllowSwitchToSubtypes) => {
  // TODO: for Discover, we should only show the active visualization subtypes till we fix how the communication with Discover works
  if (onlyAllowSwitchToSubtypes) {
    return {
      [activeVisualizationId]: visualizationMap[activeVisualizationId]
    };
  }
  const availableVisualizationMap = {
    ...visualizationMap
  };

  // hides legacy metric for ES|QL charts
  Object.keys(availableVisualizationMap).forEach(key => {
    var _availableVisualizati, _availableVisualizati2;
    if ((_availableVisualizati = availableVisualizationMap[key]) !== null && _availableVisualizati !== void 0 && (_availableVisualizati2 = _availableVisualizati.hideFromChartSwitch) !== null && _availableVisualizati2 !== void 0 && _availableVisualizati2.call(_availableVisualizati, frame)) {
      delete availableVisualizationMap[key];
    }
  });
  return availableVisualizationMap;
};