"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeScaling = TimeScaling;
exports.setTimeScaling = setTimeScaling;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _operations = require("../operations");
var _suffix_formatter = require("../../../../common/suffix_formatter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/time_scaling.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function setTimeScaling(columnId, layer, timeScale) {
  const currentColumn = layer.columns[columnId];
  const label = currentColumn.customLabel ? currentColumn.label : (0, _operations.adjustTimeScaleLabelSuffix)(currentColumn.label, currentColumn.timeScale, timeScale, currentColumn.timeShift, currentColumn.timeShift, currentColumn.reducedTimeRange, currentColumn.reducedTimeRange);
  return {
    ...layer,
    columns: {
      ...layer.columns,
      [columnId]: {
        ...layer.columns[columnId],
        label,
        timeScale
      }
    }
  };
}
function TimeScaling({
  selectedColumn,
  columnId,
  layer,
  updateLayer
}) {
  var _selectedColumn$timeS;
  const selectedOperation = _operations.operationDefinitionMap[selectedColumn.operationType];
  if (!selectedOperation.timeScalingMode || selectedOperation.timeScalingMode === 'disabled') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.timeScale.label', {
      defaultMessage: 'Normalize by unit'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "question",
      color: "subdued",
      size: "s",
      className: "eui-alignTop",
      content: _i18n.i18n.translate('xpack.lens.indexPattern.timeScale.tooltip', {
        defaultMessage: 'Normalize values to be always shown as rate per specified time unit, regardless of the underlying date interval.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    compressed: true,
    options: [{
      value: '',
      text: _i18n.i18n.translate('xpack.lens.timeScale.normalizeNone', {
        defaultMessage: 'None'
      })
    }, ...Object.entries(_suffix_formatter.unitSuffixesLong).map(([unit, text]) => ({
      value: unit,
      text
    }))],
    "data-test-subj": "indexPattern-time-scaling-unit",
    value: (_selectedColumn$timeS = selectedColumn.timeScale) !== null && _selectedColumn$timeS !== void 0 ? _selectedColumn$timeS : '',
    onChange: e => {
      const value = e.target.value || undefined;
      updateLayer(setTimeScaling(columnId, layer, value));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }))));
}