"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorViewChooser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/ui/inspector_view_chooser.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class InspectorViewChooser extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isSelectorOpen: false
    });
    (0, _defineProperty2.default)(this, "toggleSelector", () => {
      this.setState(prev => ({
        isSelectorOpen: !prev.isSelectorOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closeSelector", () => {
      this.setState({
        isSelectorOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderView", (view, index) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: index,
        onClick: () => {
          this.props.onViewSelected(view);
          this.closeSelector();
        },
        toolTipContent: view.help,
        toolTipProps: {
          position: 'left'
        },
        "data-test-subj": `inspectorViewChooser${view.title}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 7
        }
      }, view.title);
    });
  }
  renderViewButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: this.toggleSelector,
      "data-test-subj": "inspectorViewChooser",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.view",
      defaultMessage: "View: {viewName}",
      values: {
        viewName: this.props.selectedView.title
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }));
  }
  renderSingleView() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: this.props.selectedView.help,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.view",
      defaultMessage: "View: {viewName}",
      values: {
        viewName: this.props.selectedView.title
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }));
  }
  render() {
    const {
      views
    } = this.props;
    if (views.length < 2) {
      return this.renderSingleView();
    }
    const triggerButton = this.renderViewButton();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "inspectorViewChooser",
      button: triggerButton,
      isOpen: this.state.isSelectorOpen,
      closePopover: this.closeSelector,
      panelPaddingSize: "none",
      anchorPosition: "downRight",
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: views.map(this.renderView),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }));
  }
}
exports.InspectorViewChooser = InspectorViewChooser;
(0, _defineProperty2.default)(InspectorViewChooser, "propTypes", {
  views: _propTypes.default.array.isRequired,
  onViewSelected: _propTypes.default.func.isRequired,
  selectedView: _propTypes.default.object.isRequired
});