"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flyoutOptions = exports.InspectFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _data_section = require("./data_section/data_section");
var _inspect_flyout_header = require("./inspect_flyout_header");
var _actions_section = require("./actions_section/actions_section");
var _inspect_highlight = require("../overlay/inspect_highlight");
var _constants = require("../../../lib/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/inspect_component/public/components/inspect/flyout/inspect_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const flyoutOptions = exports.flyoutOptions = {
  size: 's',
  'data-test-subj': _constants.INSPECT_FLYOUT_ID,
  id: _constants.INSPECT_FLYOUT_ID,
  maxWidth: _constants.INSPECT_FLYOUT_MAX_WIDTH
};
const InspectFlyout = ({
  componentData,
  target,
  branch
}) => {
  var _componentData$source;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [highlightPosition, setHighlightPosition] = (0, _react.useState)(null);
  const toastZIndex = Number(euiTheme.levels.toast);
  const updateHighlightPosition = (0, _react.useCallback)(() => {
    const rect = target.getBoundingClientRect();
    setHighlightPosition({
      position: 'fixed',
      top: `${rect.top}px`,
      left: `${rect.left}px`,
      width: `${rect.width}px`,
      height: `${rect.height}px`,
      zIndex: toastZIndex + 1
    });
  }, [target, toastZIndex]);

  /** Set initial highlight position. */
  (0, _react.useLayoutEffect)(() => {
    if (!target) return;
    updateHighlightPosition();
  }, [updateHighlightPosition, target]);

  /** Update z-index of the flyout to be above portal elements. */
  (0, _react.useLayoutEffect)(() => {
    const flyoutElement = document.getElementById(_constants.INSPECT_FLYOUT_ID);
    const portalParent = flyoutElement === null || flyoutElement === void 0 ? void 0 : flyoutElement.closest(_constants.EUI_PORTAL_ATTRIBUTE);
    if (portalParent instanceof HTMLElement) {
      requestAnimationFrame(() => {
        portalParent.style.zIndex = (toastZIndex + 2).toString();
      });
    }
  }, [toastZIndex]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: updateHighlightPosition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_inspect_flyout_header.InspectFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_data_section.DataSection, {
    componentData: componentData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_actions_section.ActionsSection, {
    componentData: componentData,
    branch: branch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  })), highlightPosition && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_inspect_highlight.InspectHighlight, {
    currentPosition: highlightPosition,
    path: (componentData === null || componentData === void 0 ? void 0 : (_componentData$source = componentData.sourceComponent) === null || _componentData$source === void 0 ? void 0 : _componentData$source.type) || null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  })));
};
exports.InspectFlyout = InspectFlyout;